/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> mFunction;
    private T mResult = null;
    private boolean mHasResult = false;

    public Lazy(@NotNull Supplier<T> fn) {
        this.mFunction = fn;
    }

    @NotNull
    public static <T> Lazy<T> of(@NotNull T value) {
        return new Lazy<Object>(() -> value);
    }

    @NotNull
    public static <T> Lazy<T> of(@NotNull Supplier<T> fn) {
        return new Lazy<T>(fn);
    }

    @NotNull
    public <U> Lazy<U> map(@NotNull Function<? super T, U> fn) {
        return new Lazy<Object>(() -> fn.apply((T)this.get()));
    }

    @Override
    public T get() {
        if (!this.mHasResult) {
            this.mHasResult = true;
            this.mResult = this.mFunction.get();
        }
        return this.mResult;
    }
}

