/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GlobalConfig {
    public static final String THREADS_JSON_NAME = "threads";
    @SerializedName(value="threads")
    public Integer threadsNum = null;
    public static final String VERBOSE_JSON_NAME = "verbose";
    @SerializedName(value="verbose")
    public Boolean verbose = null;
    public static final String TIMEOUT_JSON_NAME = "timeout";
    @SerializedName(value="timeout")
    public Integer timeout = null;
    public static final String JAVA_JSON_NAME = "java";
    @SerializedName(value="java")
    public String javaPath = null;
    public static final String JVM_ARGUMENTS_JSON_NAME = "jvm-arguments";
    @SerializedName(value="jvm-arguments")
    public List<String> jvmArguments = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected static GlobalConfig readFromStandardPath() {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH));){
            GlobalConfig globalConfig = (GlobalConfig)new GsonBuilder().setLenient().create().fromJson(reader, GlobalConfig.class);
            return globalConfig;
        }
        catch (IOException e) {
            throw new PvsStudioException("Couldn't read global settings file", e);
        }
    }

    protected void writeToStandardPath() {
        File globalConfigFile = new File(AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH);
        Utils.createDirectoriesToFile(globalConfigFile);
        try (FileWriter writer = new FileWriter(globalConfigFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new PvsStudioException("Couldn't write to global settings file", e);
        }
    }

    protected static boolean existsOnStandardPath() {
        return new File(AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH).exists();
    }
}

