/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Box<T> {
    private static final Box<?> EMPTY = new Box<Object>(null);
    private final T item;

    private Box(T item) {
        this.item = item;
    }

    @NotNull
    public static <T> Box<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> Box<T> ofNullable(@Nullable T item) {
        return item == null ? Box.empty() : new Box<T>(item);
    }

    @NotNull
    public static <T> Box<T> of(@NotNull T item) {
        return Box.ofNullable(Objects.requireNonNull(item));
    }

    @NotNull
    public static <T> Box<T> fromOptional(@NotNull Optional<T> optional) {
        Objects.requireNonNull(optional);
        return optional.isPresent() ? Box.of(optional.get()) : Box.empty();
    }

    @NotNull
    public Optional<T> toOptional() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.item);
    }

    @NotNull
    public <R> Box<R> safeCast(@NotNull Class<R> target) {
        Objects.requireNonNull(target);
        return this.isEmpty() || !target.isInstance(this.item) ? Box.empty() : this;
    }

    @NotNull
    public Box<T> filter(@NotNull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return this.isEmpty() || !predicate.test(this.item) ? Box.empty() : this;
    }

    @NotNull
    public <R> Box<R> map(@NotNull Function<T, R> mapper) {
        Objects.requireNonNull(mapper);
        return this.isEmpty() ? Box.empty() : Box.ofNullable(mapper.apply(this.item));
    }

    @NotNull
    public <R> Box<R> flatMap(@NotNull Function<T, Box<R>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Box.empty();
        }
        Box<R> result = mapper.apply(this.item);
        return result == null ? Box.empty() : result;
    }

    @NotNull
    public <R> Box<R> swap(@NotNull Function<Box<T>, Box<R>> mapper) {
        Objects.requireNonNull(mapper);
        Box<R> result = mapper.apply(this);
        return result == null ? Box.empty() : result;
    }

    public boolean isEmpty() {
        return this.item == null;
    }

    public boolean isPresent() {
        return this.item != null;
    }

    @NotNull
    public T get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.item;
    }

    @Nullable
    public T getOrDefault(@Nullable T value) {
        return this.isEmpty() ? value : this.item;
    }

    public void filter() {
    }
}

