/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.pvsstudio.AbstractConfig;
import com.pvsstudio.GlobalConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import com.pvsstudio.WarningGroup;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import picocli.CommandLine;

@CommandLine.Command(synopsisHeading="%n", customSynopsis={"java -jar pvs-studio.jar [options]%n"}, optionListHeading="Options:%n", separator=" ", sortOptions=false, footer={"*"}, showDefaultValues=true)
public class AnalyzerConfig
extends AbstractConfig {
    public static final String PVS_JAVA_ANALYZER_JAR_NAME = "pvs-studio.jar";
    public static final String PVS_JAVA_GLOBAL_JSON_FILE_NAME_WITH_EXTENSION = "global.json";
    public static final String PVS_JAVA_LICENSE_FILE_WITH_EXTENSION = "PVS-Studio.lic";
    private static final String PVS_STUDIO_JAVA_FOLDER_NAME = "PVS-Studio-Java";
    public static final String PVS_STUDIO_FOLDER_NAME = "PVS-Studio";
    private static final String PVS_STUDIO_SETTINGS_XML_FILE_NAME_WITH_EXTENSION = "Settings.xml";
    private static final String USER_CONFIG_FOLDER_PATH_ON_LINUX_OR_MACOS = "~/.config";
    public static final String PVS_JAVA_STANDARD_DIRECTORY;
    public static final String PVS_STANDARD_DIRECTORY;
    public static String PVS_JAVA_ANALYZER_CORE_DIRECTORY;
    public static String PVS_JAVA_ANALYZER_CORE_EXECUTABLE;
    public static final String PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH;
    public static final String PVS_LICENSE_FILE;
    public static final String PVS_JAVA_LICENSE_FILE;
    public static final String PVS_JAVA_PROJECT_SETTINGS_FOLDER = ".PVS-Studio";
    public static final String PVS_JAVA_LOGS_DIRECTORY = ".PVS-Studio/logs";
    private static final String PVS_JAVA_LOG_FILENAME = "pvs.log";
    private static final String PVS_JAVA_SPOON_LOG_FILENAME = "spoon.log";
    public static final String SPOON_MODEL_LOCATION = ".PVS-Studio/models";
    public static final String CONFIG_FILENAME = "settings.json";
    public static final String TEMP_ARGS_FOR_JAVA_CORE_FILE_NAME = "temp_cmd_args.json";
    public static final String PVS_JAVA_SUPPRESS_FILENAME = "suppress_base.json";
    public static final String HTTP_SERVER_RELEASE = "http://files.pvs-studio.com/java";
    public static final String HTTP_SERVER_RELEASE_CORES = "http://files.pvs-studio.com/java/pvsstudio-cores";
    public static final String HTTP_SERVER_BETA = "http://files.pvs-studio.com/java/beta";
    public static final String HTTP_SERVER_BETA_CORES = "http://files.pvs-studio.com/java/beta/pvsstudio-cores";
    public static final String HTTP_GLOBAL_VERSION_PVS = "https://pvs-studio.com/version.xml";
    @NeedMakeAbsolutePath
    @SerializedName(value="src")
    @CommandLine.Option(names={"-s", "--src"}, paramLabel="DIR|FILE", arity="1..*", description={"Set of .java files or directories for analysis."})
    @NotNull
    public Set<String> sources;
    @NeedMakeAbsolutePath
    @SerializedName(value="ext")
    @CommandLine.Option(names={"-e", "--ext"}, paramLabel="DIR|FILE", arity="1..*", description={"Set of classpath entries (.jar or .class files)."})
    @NotNull
    public Set<String> externals;
    @NeedMakeAbsolutePath
    @SerializedName(value="ext-file")
    @CommandLine.Option(names={"--ext-file"}, paramLabel="FILE", description={"File with classpath entries."})
    @Nullable
    public String externalsFile;
    @SerializedName(value="threads")
    @CommandLine.Option(names={"-j", "--threads"}, paramLabel="N", description={"Number of analysis threads."})
    @NotNull
    public Integer threadsNum;
    @NeedMakeAbsolutePath
    @SerializedName(value="output-file")
    @CommandLine.Option(names={"-o", "--output-file"}, paramLabel="FILE", description={"Output file with analyzer report."})
    @Nullable
    public String outputFile;
    @SerializedName(value="output-type")
    @CommandLine.Option(names={"-O", "--output-type"}, paramLabel="TYPE", description={"Output format (text, log, json, xml, tasklist, html, fullhtml, errorfile)."})
    @NotNull
    public String outputType;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="incremental")
    @CommandLine.Option(names={"-i", "--incremental"}, description={"Analyze only changed files."})
    @NotNull
    public Boolean incremental;
    public static final String CFG_CMD_ARGUMENT_FULL_NAME = "--cfg";
    @ExcludeFromSerialization
    @NeedMakeAbsolutePath
    @CommandLine.Option(names={"-c", "--cfg"}, paramLabel="FILE", description={"Configuration file."})
    @Nullable
    public String configFile;
    @ExcludeFromSerialization
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="help")
    @CommandLine.Option(names={"-h", "--help"}, description={"Analyzer command line help."})
    @Nullable
    public Boolean helpRequired;
    @NeedMakeAbsolutePath
    @SerializedName(value="sourcetree-root")
    @CommandLine.Option(names={"--sourcetree-root"}, paramLabel="PATH", description={"Replace absolute paths in report."})
    @Nullable
    public String sourceTreeRoot;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="force-rebuild")
    @CommandLine.Option(names={"--force-rebuild"}, description={"Force to perform full model rebuild."})
    @NotNull
    public Boolean forceRebuild;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="disable-cache")
    @CommandLine.Option(names={"--disable-cache"}, description={"Disable caching."})
    @NotNull
    public Boolean disableCache;
    @SerializedName(value="exclude")
    @CommandLine.Option(names={"--exclude"}, paramLabel="DIR|FILE", arity="1..*", description={"Exclude these files or directories from analysis."})
    @NotNull
    public List<String> exclude;
    @SerializedName(value="analyze-only")
    @CommandLine.Option(names={"--analyze-only"}, paramLabel="DIR|FILE", arity="1..*", description={"Run analysis only on these files or directories."})
    @NotNull
    public Set<String> analyzeOnly;
    @NeedMakeAbsolutePath
    @SerializedName(value="analyze-only-list")
    @CommandLine.Option(names={"--analyze-only-list"}, paramLabel="FILE", description={"Path to the text file containing a list of paths to files and/or directories for analysis (each entry must be on a separate line)"})
    @Nullable
    public String analyzeOnlyList;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="fail-on-warnings")
    @CommandLine.Option(names={"--fail-on-warnings"}, description={"Return 53 if report contains any warnings"})
    @NotNull
    public Boolean failOnWarnings;
    @SerializedName(value="analysis-mode")
    @CommandLine.Option(names={"--analysis-mode"}, paramLabel="ga|owasp", converter={WarningGroupConverter.class}, arity="1..*", description={"Enabled warning groups."})
    @NotNull
    public Set<WarningGroup> analysisMode;
    @SerializedName(value="disabled-warnings")
    @CommandLine.Option(names={"--disabled-warnings"}, paramLabel="V6XXX", arity="1..*", description={"Disable these warnings."})
    @NotNull
    public Set<String> disabledWarnings;
    @SerializedName(value="enabled-warnings")
    @CommandLine.Option(names={"--enabled-warnings"}, paramLabel="V6XXX", arity="1..*", description={"Enable only these warnings."})
    @NotNull
    public Set<String> enabledWarnings;
    @SerializedName(value="additional-warnings")
    @CommandLine.Option(names={"--additional-warnings"}, paramLabel="V6XXX", arity="1..*", description={"Unconditionally enable these warnings."})
    @NotNull
    public Set<String> additionalWarnings;
    @SerializedName(value="suppress-base")
    @CommandLine.Option(names={"--suppress-base"}, paramLabel="FILE", description={"Path to a suppress file, containing suppressed analyzer messages, that will not be included in analyzer's report."})
    @NotNull
    public String suppressBase;
    @SerializedName(value="timeout")
    @CommandLine.Option(names={"--timeout"}, paramLabel="MINUTES", description={"Timeout for analyzing a single file."})
    @NotNull
    public Integer timeout;
    @NeedMakeAbsolutePath
    @SerializedName(value="license-path")
    @CommandLine.Option(names={"--license-path"}, paramLabel="FILE", description={"Path to the license file."})
    @Nullable
    public String licensePath;
    public static final String CONVERT_TO_SUPPRESS_FILE_COMMAND_LINE_ARGUMENT_VALUE = "toSuppress";
    @SerializedName(value="convert")
    @CommandLine.Option(names={"--convert"}, paramLabel="OP", description={"Report conversion (toFullhtml, toSuppress)"})
    @Nullable
    public String convert;
    @SerializedName(value="src-convert")
    @CommandLine.Option(names={"--src-convert"}, paramLabel="FILE", description={"Report file (*.json) to convert"})
    @Nullable
    public String srcConvert;
    @SerializedName(value="dst-convert")
    @CommandLine.Option(names={"--dst-convert"}, paramLabel="DIR|FILE", description={"Destination of the conversion result\n(file(toSuppress) or dir(toFullhtml))"})
    @Nullable
    public String dstConvert;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="compatibility")
    @CommandLine.Option(names={"--compatibility"}, description={"Enable the V6078 diagnostic rule, that detects potential API compatibility issues between the chosen Java SE versions."})
    @NotNull
    public Boolean compatibility;
    @SerializedName(value="source-java")
    @CommandLine.Option(names={"--source-java"}, paramLabel="N", description={"Source Java SE version."})
    @Nullable
    public Integer sourceJava;
    @SerializedName(value="target-java")
    @CommandLine.Option(names={"--target-java"}, paramLabel="N", description={"Target Java SE version."})
    @Nullable
    public Integer targetJava;
    @SerializedName(value="exclude-packages")
    @CommandLine.Option(names={"--exclude-packages"}, paramLabel="NAME", arity="1..*", description={"Exclude packages from compatibility analysis."})
    @NotNull
    public Set<String> excludePackages;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="activate-license")
    @CommandLine.Option(names={"--activate-license"}, description={"License activation"})
    @NotNull
    public Boolean activateLicense;
    @ExcludeFromSerialization
    @SerializedName(value="license-key")
    @CommandLine.Option(names={"--license-key"}, paramLabel="LICENSE_KEY", description={"License key."})
    @NotNull
    private String licenseKey;
    @ExcludeFromSerialization
    @SerializedName(value="userName")
    @CommandLine.Option(names={"--user-name"}, paramLabel="NAME", description={"User name."})
    @NotNull
    private String userName;
    @ExcludeFromSerialization
    @SerializedName(value="username")
    @CommandLine.Option(names={"--username"}, paramLabel="NAME", description={"User name."}, hidden=true)
    @NotNull
    private String username;
    @ExcludeFromSerialization
    @SerializedName(value="serial-number")
    @CommandLine.Option(names={"--serial-number"}, paramLabel="NUMBER", description={"Serial number."}, hidden=true)
    @NotNull
    private String serialNumber;
    @SerializedName(value="version")
    @CommandLine.Option(hidden=true, names={"--version"}, description={"Displays the full version of the Java core to the console."})
    @BooleanFlagDefaultValue(value=false)
    public Boolean getVersion;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="is-java-core-subprocess-with-add-opens-for-native-libs-field-reflective-access")
    @CommandLine.Option(hidden=true, names={"--isJavaCoreSubprocessWithAddOpensForNativeLibsFieldReflectiveAccess"}, description={"Flag indicating that this is a process restart Java Analyzer core with arguments: --add-opens java.base/jdk.internal.loader=ALL-UNNAMED"})
    @NotNull
    public Boolean isJavaCoreSubprocessWithAddOpensForNativeLibsFieldReflectiveAccess;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="write-to-stdout")
    @CommandLine.Option(hidden=true, names={"-w", "--writeToStdout"}, description={"If the flag is true, then outputs analyzer warnings in RawJson format to stdout of the analyzer's Java core process"})
    @NotNull
    public Boolean writeToStdout;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="verbose")
    @CommandLine.Option(hidden=true, names={"-v", "--verbose"}, description={"Verbose mode. Helpful for troubleshooting."})
    @NotNull
    public Boolean verbose;
    @NeedMakeAbsolutePath
    @SerializedName(value="debug-log")
    @CommandLine.Option(hidden=true, names={"--debug-log"}, paramLabel="FILE", description={"Debug logger output directory."})
    @Nullable
    public String debugLog;
    @SerializedName(value="skip-modules")
    @CommandLine.Option(hidden=true, names={"--skip-modules"}, paramLabel="Name", arity="1..*", description={"Modules that are skipped during model building and analysis."})
    @NotNull
    public Set<String> skipModules;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="include-generated")
    @CommandLine.Option(hidden=true, names={"--include-generated"}, description={"Do not skip generated sources."})
    @NotNull
    public Boolean includeGenerated;
    @SerializedName(value="launch-mode")
    @CommandLine.Option(hidden=true, names={"--launch-mode"}, paramLabel="CORE|GRADLE|MAVEN|IDEA|VSCODE", converter={LaunchModeConverter.class})
    @NotNull
    public LaunchMode launchMode;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="enable-all-warnings")
    @CommandLine.Option(hidden=true, names={"--enable-all-warnings"})
    @NotNull
    public Boolean enableAllWarnings;
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="benchmark")
    @CommandLine.Option(hidden=true, names={"--benchmark"})
    @NotNull
    public Boolean benchmark;
    @NeedMakeAbsolutePath
    @SerializedName(value="benchmark-path")
    @CommandLine.Option(hidden=true, names={"--benchmark-path"})
    @Nullable
    public String benchmarkPath;
    @NeedMakeAbsolutePath
    @SerializedName(value="merge-benchmark")
    @CommandLine.Option(hidden=true, names={"--merge-benchmark"})
    @Nullable
    public String mergeBenchmarkPath;
    @SerializedName(value="java")
    @CommandLine.Option(hidden=true, names={"--java-path"}, description={"This setting allows you to override the path to the java(.exe) file that will be used to run the Java analyzer core. By default, the java(.exe) file from the JDK installed in the system (the PATH system variable) is used to run the Java analyzer core. This argument is NOT USED when running pvs-studio.jar directly from the console."})
    @Nullable
    public String javaPath;
    @SerializedName(value="jvm-arguments")
    @CommandLine.Option(hidden=true, names={"--jvm-arguments"}, arity="1..*", description={"Additional JVM flags with which the analyzer core will be launched. This argument is NOT USED when running pvs-studio.jar directly from the console."})
    @NotNull
    public List<String> jvmArguments;
    @SerializedName(value="traceLogFileName")
    @CommandLine.Option(names={"--traceLogFileName"}, paramLabel="FILE", description={"Only file name"}, hidden=true, defaultValue="pvs.log")
    @Nullable
    public String traceLogFileName;
    @SerializedName(value="traceSpoonLogFileName")
    @CommandLine.Option(names={"--traceSpoonLogFileName"}, paramLabel="FILE", description={"Only file name"}, hidden=true, defaultValue="spoon.log")
    @Nullable
    public String traceSpoonLogFileName;
    public static final String CHECK_LICENSE_ARG_FULL_NAME = "--check-license";
    @BooleanFlagDefaultValue(value=false)
    @SerializedName(value="check-license")
    @CommandLine.Option(hidden=true, names={"--check-license"})
    @NotNull
    public Boolean checkLicense;
    @SerializedName(value="sonarqubedata")
    @CommandLine.Option(hidden=true, names={"--sonarqubedata"}, paramLabel="FILE", description={"Output file for SonarQube (*.properties)"})
    @Nullable
    public String sonarQubeData;
    @SerializedName(value="logging")
    @CommandLine.Option(hidden=true, names={"--logging"}, paramLabel="LEVEL", description={"Logging level."})
    @NotNull
    public String logging;
    @NeedMakeAbsolutePath
    @SerializedName(value="project")
    @CommandLine.Option(hidden=true, names={"-p", "--project"}, paramLabel="DIR", description={"Project path. Incompatible with -s and -e."})
    @NotNull
    public String projectPath;
    @SerializedName(value="type")
    @CommandLine.Option(hidden=true, names={"-t", "--type"}, paramLabel="TYPE", description={"Project type (sources, json)."})
    @NotNull
    public String projectType;
    public static final String ADD_OPENS_JDK_FLAG = "--add-opens";
    public static final String NEED_FOR_JAVA_CORE_ADD_OPENS_MODULE_JDK_FLAG_ARGUMENT = "java.base/jdk.internal.loader=ALL-UNNAMED";

    public AnalyzerConfig() {
    }

    private AnalyzerConfig(@NotNull AnalyzerConfig other) {
        this.fillNonStaticFieldsFrom(other);
    }

    @NotNull
    public AnalyzerConfig copy() {
        return new AnalyzerConfig(this);
    }

    protected final void fillNonStaticFieldsFrom(@NotNull AnalyzerConfig other) {
        try {
            for (Field nonStaticField : AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class)) {
                nonStaticField.set(this, nonStaticField.get(other));
            }
        }
        catch (IllegalAccessException e) {
            throw new PvsStudioException("couldn't copy AnalyzerConfig", e);
        }
    }

    public static Field[] getNonStaticFields(@NotNull Class<?> clazz) {
        return (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
    }

    @NotNull
    public static AnalyzerConfig blankConfig() {
        return new AnalyzerConfig();
    }

    @NotNull
    public static AnalyzerConfig getGlobalConfig() {
        AnalyzerConfig res = AnalyzerConfig.blankConfig();
        AnalyzerConfig.fillSettingsInLocalConfig(res);
        return res;
    }

    @NotNull
    public String getLicenseKey() {
        if (StringUtils.isEmpty((CharSequence)this.licenseKey)) {
            return this.serialNumber;
        }
        return this.licenseKey;
    }

    public void setLicenseKey(@NotNull String value) {
        this.licenseKey = value;
        this.serialNumber = value;
    }

    @NotNull
    public String getUserName() {
        if (StringUtils.isEmpty((CharSequence)this.userName)) {
            return this.username;
        }
        return this.userName;
    }

    public void setUserName(@NotNull String value) {
        this.userName = value;
        this.username = value;
    }

    public static void updateAnalyzerVersion(String newVersion) {
        PVS_JAVA_ANALYZER_CORE_DIRECTORY = Utils.absolutePath(PVS_JAVA_STANDARD_DIRECTORY, newVersion);
        PVS_JAVA_ANALYZER_CORE_EXECUTABLE = Utils.absolutePath(PVS_JAVA_ANALYZER_CORE_DIRECTORY, PVS_JAVA_ANALYZER_JAR_NAME);
    }

    private void createRollingFileAppender(String loggerName, String logFile, String rollingAppenderName, Level level) {
        LoggerContext logCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext((Context)logCtx);
        logEncoder.setPattern("%d{yyyy-MM-dd HH:mm:ss} [%-5p] %c{1}:%L - %m%n");
        logEncoder.start();
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setContext((Context)logCtx);
        fileAppender.setName(rollingAppenderName);
        fileAppender.setEncoder((Encoder)logEncoder);
        fileAppender.setFile(logFile);
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setMaxFileSize(FileSize.valueOf((String)"7MB"));
        triggeringPolicy.start();
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext((Context)logCtx);
        rollingPolicy.setParent((FileAppender)fileAppender);
        rollingPolicy.setFileNamePattern(FilenameUtils.removeExtension((String)logFile) + "_%i.log");
        rollingPolicy.setMaxIndex(10);
        rollingPolicy.start();
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        fileAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        fileAppender.start();
        Logger logger = logCtx.getLogger(loggerName);
        logger.setAdditive(false);
        logger.setLevel(level);
        logger.addAppender((Appender)fileAppender);
    }

    public void configureLogger() {
        if (this.debugLog == null) {
            return;
        }
        File[] files = new File(this.debugLog).listFiles();
        if (files != null) {
            Arrays.stream(files).filter(file -> FilenameUtils.getExtension((String)file.getName()).equals("log")).forEach(File::delete);
        }
        this.createRollingFileAppender("com.pvsstudio", new File(this.debugLog, this.traceLogFileName).getAbsolutePath(), "PVS_APPENDER", Level.toLevel((String)this.logging, (Level)Level.OFF));
        this.createRollingFileAppender("spoon", new File(this.debugLog, this.traceSpoonLogFileName).getAbsolutePath(), "SPOON_APPENDER", Level.WARN);
    }

    @Nullable
    public static String getExistLicenseFileStandardPath() {
        if (new File(PVS_LICENSE_FILE).exists()) {
            return PVS_LICENSE_FILE;
        }
        if (new File(PVS_JAVA_LICENSE_FILE).exists()) {
            return PVS_JAVA_LICENSE_FILE;
        }
        return null;
    }

    public void readLicenseFile(@NotNull String path) throws PvsStudioException {
        try {
            if (path.endsWith(".xml")) {
                String licenseInfo = Utils.getLicenseInfoFromSettingsXml(path);
                String[] split = licenseInfo.split(System.lineSeparator());
                if (split.length == 2) {
                    this.setUserName(split[0] != null ? split[0] : "");
                    this.setLicenseKey(split[1] != null ? split[1] : "");
                }
            } else if (path.endsWith(".lic")) {
                List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
                if (lines.size() != 2) {
                    throw new PvsStudioException("expected 2 lines, got " + lines.size());
                }
                this.setUserName(lines.get(0).replaceAll("\ufeff", "").trim());
                this.setLicenseKey(lines.get(1).trim());
            }
        }
        catch (Exception e) {
            throw new PvsStudioException("Couldn't read license file: " + path, e);
        }
    }

    @NotNull
    public void normalize() {
        if (this.threadsNum == null) {
            this.threadsNum = Utils.getRecommendedThreadsCount();
        }
        if (this.outputType == null) {
            this.outputType = "json";
        }
        if (this.projectPath == null) {
            this.projectPath = Utils.absolutePath(".");
        }
        if (this.projectType == null) {
            this.projectType = "sources";
        }
        if (this.suppressBase == null || !new File(this.suppressBase).isAbsolute()) {
            String rel = this.suppressBase == null ? new File(PVS_JAVA_PROJECT_SETTINGS_FOLDER, PVS_JAVA_SUPPRESS_FILENAME).getPath() : new File(this.suppressBase).getPath();
            this.suppressBase = new File(this.projectPath, rel).getPath();
        }
        if (this.logging == null) {
            this.logging = "OFF";
        }
        if (!(Level.toLevel((String)this.logging, (Level)Level.OFF) == Level.OFF || this.debugLog != null && this.debugLog.startsWith(this.projectPath))) {
            this.debugLog = Utils.absolutePath(new File(this.projectPath, PVS_JAVA_LOGS_DIRECTORY)).getPath();
        }
        if (this.jvmArguments == null || this.jvmArguments.isEmpty()) {
            this.jvmArguments = new ArrayList<String>();
            this.jvmArguments.add("-Xss64m");
        }
        if (this.analysisMode == null) {
            this.analysisMode = new HashSet<WarningGroup>();
        }
        this.analysisMode.remove((Object)WarningGroup.UNKNOWN);
        if (this.analysisMode.isEmpty()) {
            this.analysisMode.add(WarningGroup.GA);
        }
        if (this.launchMode == null) {
            this.launchMode = LaunchMode.CORE;
        }
        if (this.timeout == null) {
            this.timeout = 10;
        }
        for (Field nonStaticField : AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class)) {
            try {
                Object argsField = nonStaticField.get(this);
                if (argsField != null) {
                    nonStaticField.set(this, argsField);
                    if (nonStaticField.isAnnotationPresent(NeedMakeAbsolutePath.class)) {
                        if (nonStaticField.getType() == String.class) {
                            nonStaticField.set(this, Utils.absolutePath((String)argsField));
                            continue;
                        }
                        if (nonStaticField.getType() != Set.class || ((ParameterizedType)nonStaticField.getGenericType()).getActualTypeArguments()[0] != String.class) continue;
                        nonStaticField.set(this, ((Set)argsField).stream().map(Utils::absolutePath).collect(Collectors.toSet()));
                        continue;
                    }
                    if (nonStaticField.getType() == Set.class && ((ParameterizedType)nonStaticField.getGenericType()).getActualTypeArguments()[0] == String.class) {
                        nonStaticField.set(this, ((Set)argsField).stream().map(String::trim).collect(Collectors.toSet()));
                        continue;
                    }
                    if (nonStaticField.getType() != List.class || ((ParameterizedType)nonStaticField.getGenericType()).getActualTypeArguments()[0] != String.class) continue;
                    nonStaticField.set(this, ((List)argsField).stream().map(String::trim).collect(Collectors.toList()));
                    continue;
                }
                if (nonStaticField.getType() == Boolean.class) {
                    BooleanFlagDefaultValue annotation = nonStaticField.getAnnotation(BooleanFlagDefaultValue.class);
                    if (annotation == null) continue;
                    nonStaticField.set(this, annotation.value());
                    continue;
                }
                if (nonStaticField.getType() == List.class) {
                    nonStaticField.set(this, new ArrayList());
                    continue;
                }
                if (nonStaticField.getType() != Set.class) continue;
                nonStaticField.set(this, new HashSet());
            }
            catch (IllegalAccessException e) {
                throw new PvsStudioException("Invalid type", e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.getUserName()) && StringUtils.isEmpty((CharSequence)this.getLicenseKey())) {
            if (new File(PVS_LICENSE_FILE).exists()) {
                this.readLicenseFile(PVS_LICENSE_FILE);
            } else if (new File(PVS_JAVA_LICENSE_FILE).exists()) {
                this.readLicenseFile(PVS_JAVA_LICENSE_FILE);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.getUserName())) {
            this.setUserName("");
        }
        if (StringUtils.isEmpty((CharSequence)this.getLicenseKey())) {
            this.setLicenseKey("");
        }
    }

    @NotNull
    public static AnalyzerConfig mergeAndNormalizeAfterMerge(@NotNull AnalyzerConfig argsConfig, @NotNull AnalyzerConfig jsonConfig, @NotNull AnalyzerConfig globalConfig) {
        AnalyzerConfig result = AnalyzerConfig.blankConfig();
        try {
            for (Field nonStaticField : AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class)) {
                Object argsField = nonStaticField.get(argsConfig);
                Object jsonField = nonStaticField.get(jsonConfig);
                Object globalField = nonStaticField.get(globalConfig);
                Object resultConfigFieldValue = argsField != null ? argsField : (jsonField != null ? jsonField : globalField);
                nonStaticField.set(result, resultConfigFieldValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to merge configurations", e);
        }
        result.normalize();
        return result;
    }

    @NotNull
    public String getPathForTempArgsConfigJsonFile() {
        return Utils.joinPath(this.projectPath, PVS_JAVA_PROJECT_SETTINGS_FOLDER, TEMP_ARGS_FOR_JAVA_CORE_FILE_NAME);
    }

    @NotNull
    public List<String> getCommandLineForRunJavaCoreWithTempCfgFileCreation() {
        ArrayList<String> commandLineForStartJavaCore = new ArrayList<String>();
        int javaCoreAddOpensModuleCommandLastIndex = this.jvmArguments.lastIndexOf(NEED_FOR_JAVA_CORE_ADD_OPENS_MODULE_JDK_FLAG_ARGUMENT);
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14)) {
            if (javaCoreAddOpensModuleCommandLastIndex == -1) {
                this.jvmArguments.add(ADD_OPENS_JDK_FLAG);
                this.jvmArguments.add(NEED_FOR_JAVA_CORE_ADD_OPENS_MODULE_JDK_FLAG_ARGUMENT);
            }
        } else {
            int beforeJavaCoreAddOpensModuleCommandArgIndex = javaCoreAddOpensModuleCommandLastIndex - 1;
            if (javaCoreAddOpensModuleCommandLastIndex >= 1 && this.jvmArguments.get(beforeJavaCoreAddOpensModuleCommandArgIndex).equals(ADD_OPENS_JDK_FLAG)) {
                this.jvmArguments.remove(javaCoreAddOpensModuleCommandLastIndex);
                this.jvmArguments.remove(beforeJavaCoreAddOpensModuleCommandArgIndex);
            }
        }
        commandLineForStartJavaCore.add(this.javaPath == null ? "java" : this.javaPath);
        commandLineForStartJavaCore.addAll(this.jvmArguments);
        commandLineForStartJavaCore.add("-jar");
        commandLineForStartJavaCore.add(this.getJavaCoreExecutableJar().getAbsolutePath());
        commandLineForStartJavaCore.add(CFG_CMD_ARGUMENT_FULL_NAME);
        String pathForTempArgsConfigJsonFile = this.getPathForTempArgsConfigJsonFile();
        commandLineForStartJavaCore.add(pathForTempArgsConfigJsonFile);
        File tempArgsConfigJsonFile = new File(pathForTempArgsConfigJsonFile);
        if (tempArgsConfigJsonFile.exists()) {
            tempArgsConfigJsonFile.delete();
        }
        this.save(pathForTempArgsConfigJsonFile);
        return commandLineForStartJavaCore;
    }

    public void createProjectDirectory() {
        File dir = new File(this.projectPath, PVS_JAVA_PROJECT_SETTINGS_FOLDER);
        if (!dir.exists() && !dir.mkdir()) {
            throw new PvsStudioException("couldn't create " + dir.getAbsolutePath());
        }
        File logs = new File(this.projectPath, PVS_JAVA_LOGS_DIRECTORY);
        if (!logs.exists() && !logs.mkdir()) {
            throw new PvsStudioException("couldn't create " + logs.getAbsolutePath());
        }
    }

    private static void fillSettingsInLocalConfig(AnalyzerConfig localConfig) {
        if (!GlobalConfig.existsOnStandardPath()) {
            return;
        }
        AnalyzerConfig.merge(GlobalConfig.readFromStandardPath(), localConfig, (globalConfigField, localConfigField, globalValue, localValue) -> {
            if (localValue == null && globalValue != null) {
                localConfigField.set(localConfig, globalValue);
            }
        });
    }

    private static GlobalConfig fillSettingsInGlobalConfig(AnalyzerConfig localConfig) {
        GlobalConfig globalConfig = GlobalConfig.existsOnStandardPath() ? GlobalConfig.readFromStandardPath() : new GlobalConfig();
        AnalyzerConfig.merge(globalConfig, localConfig, (globalConfigField, localConfigField, globalValue, localValue) -> {
            if (globalValue == null && localValue != null) {
                globalConfigField.set(globalConfig, localValue);
            }
        });
        return globalConfig;
    }

    private static void merge(@NotNull GlobalConfig globalConfig, @NotNull AnalyzerConfig localConfig, @NotNull GlobalAndLocalConfigMergeStrategy mergeStrategy) {
        for (Field globalField : AnalyzerConfig.getNonStaticFields(GlobalConfig.class)) {
            String fieldName = globalField.getName();
            try {
                Field localField = AnalyzerConfig.class.getDeclaredField(fieldName);
                Object globalValue = globalField.get(globalConfig);
                Object localValue = localField.get(localConfig);
                mergeStrategy.merge(globalField, localField, globalValue, localValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new PvsStudioException("Unable to find field: " + fieldName, e);
            }
        }
    }

    public static void fillEmptySettingsInLocalAndGlobalConfig(AnalyzerConfig localConfig) {
        AnalyzerConfig.fillSettingsInLocalConfig(localConfig);
        GlobalConfig globalConfig = AnalyzerConfig.fillSettingsInGlobalConfig(localConfig);
        globalConfig.writeToStandardPath();
    }

    public void save(@NotNull String absolutePath) {
        AnalyzerConfig.fillEmptySettingsInLocalAndGlobalConfig(this);
        ArrayList<String> oldExclude = new ArrayList<String>(this.exclude);
        this.exclude.replaceAll(path -> Utils.getProjectRelativePath(path, this.projectPath));
        this.createProjectDirectory();
        AnalyzerConfig out = this.copy();
        try {
            for (Field nonStaticField : AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class)) {
                if (nonStaticField.get(out) == null || !nonStaticField.isAnnotationPresent(ExcludeFromSerialization.class)) continue;
                nonStaticField.set(out, null);
            }
            out.suppressBase = Utils.normalizePath(out.suppressBase).replace(Utils.normalizePath(this.projectPath + "//"), "");
            if (out.debugLog != null) {
                out.debugLog = Utils.normalizePath(out.debugLog).replace(Utils.normalizePath(this.projectPath + "//"), "");
            }
            try (FileWriter writer = new FileWriter(absolutePath);){
                new GsonBuilder().setPrettyPrinting().create().toJson((Object)out, (Appendable)writer);
            }
            if (!StringUtils.isEmpty((CharSequence)this.getUserName()) || !StringUtils.isEmpty((CharSequence)this.getLicenseKey())) {
                this.writeLicenseInfo();
            }
        }
        catch (IOException | IllegalAccessException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new PvsStudioException("unable to save config: " + absolutePath, e);
        }
        this.exclude = oldExclude;
    }

    @Override
    public void saveToStandardPath() {
        this.save(Utils.joinPath(this.projectPath, PVS_JAVA_PROJECT_SETTINGS_FOLDER, CONFIG_FILENAME));
    }

    private void writeLicenseInfo() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        Utils.saveToStandardLicenseFile(this.getUserName(), this.getLicenseKey());
        System.out.println("Credentials were successfully written into " + PVS_LICENSE_FILE);
    }

    @NotNull
    public static AnalyzerConfig load(@NotNull String projectPath) throws IOException {
        AnalyzerConfig res;
        File localConfig = new File(Utils.joinPath(projectPath, PVS_JAVA_PROJECT_SETTINGS_FOLDER, CONFIG_FILENAME));
        if (localConfig.exists()) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(localConfig));){
                res = (AnalyzerConfig)new GsonBuilder().setLenient().create().fromJson(reader, AnalyzerConfig.class);
                AnalyzerConfig.fillEmptySettingsInLocalAndGlobalConfig(res);
            }
        } else {
            res = AnalyzerConfig.getGlobalConfig();
        }
        res.projectPath = projectPath;
        res.normalize();
        res.exclude.replaceAll(s -> Utils.absolutePath(res.projectPath, s));
        return res;
    }

    @NotNull
    public String projectFile(@NotNull String filename) {
        return Utils.absolutePath(this.projectPath, PVS_JAVA_PROJECT_SETTINGS_FOLDER, filename);
    }

    @NotNull
    public String logFile(@NotNull String filename) {
        return Utils.absolutePath(this.projectPath, PVS_JAVA_LOGS_DIRECTORY, filename);
    }

    @NotNull
    public static File getJavaCoreExecutableJar(@NotNull Class<?> clazz) throws PvsStudioException {
        try {
            File javaCoreExecutableJar = new File(URLDecoder.decode(clazz.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
            if (!javaCoreExecutableJar.exists()) {
                throw new PvsStudioException(javaCoreExecutableJar.getAbsolutePath() + " doesn't exist");
            }
            return javaCoreExecutableJar;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PvsStudioException("Error when calculating the path to the pvs-studio.jar file of the Java analyzer core", unsupportedEncodingException);
        }
    }

    @NotNull
    protected File getJavaCoreExecutableJar() throws PvsStudioException {
        return AnalyzerConfig.getJavaCoreExecutableJar(this.getClass());
    }

    static {
        for (Field nonStaticField : AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class)) {
            if (!nonStaticField.getType().isPrimitive()) continue;
            throw new PvsStudioException("primitive types should not be used in AnalyzerConfig");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String appData = System.getenv("APPDATA");
            appData = appData != null ? appData : System.getProperty("user.dir");
            PVS_JAVA_STANDARD_DIRECTORY = Utils.absolutePath(appData, PVS_STUDIO_JAVA_FOLDER_NAME);
            PVS_STANDARD_DIRECTORY = Utils.absolutePath(appData, PVS_STUDIO_FOLDER_NAME);
            PVS_LICENSE_FILE = Utils.absolutePath(PVS_STANDARD_DIRECTORY, PVS_STUDIO_SETTINGS_XML_FILE_NAME_WITH_EXTENSION);
        } else {
            PVS_JAVA_STANDARD_DIRECTORY = Utils.absolutePath(USER_CONFIG_FOLDER_PATH_ON_LINUX_OR_MACOS, PVS_STUDIO_JAVA_FOLDER_NAME);
            PVS_STANDARD_DIRECTORY = Utils.absolutePath(USER_CONFIG_FOLDER_PATH_ON_LINUX_OR_MACOS, PVS_STUDIO_FOLDER_NAME);
            PVS_LICENSE_FILE = Utils.absolutePath(PVS_STANDARD_DIRECTORY, PVS_JAVA_LICENSE_FILE_WITH_EXTENSION);
        }
        PVS_JAVA_ANALYZER_CORE_DIRECTORY = Utils.absolutePath(PVS_JAVA_STANDARD_DIRECTORY, "7.31.81895");
        PVS_JAVA_ANALYZER_CORE_EXECUTABLE = Utils.absolutePath(PVS_JAVA_ANALYZER_CORE_DIRECTORY, PVS_JAVA_ANALYZER_JAR_NAME);
        PVS_JAVA_LICENSE_FILE = Utils.absolutePath(PVS_JAVA_STANDARD_DIRECTORY, PVS_JAVA_LICENSE_FILE_WITH_EXTENSION);
        PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH = Utils.absolutePath(PVS_JAVA_STANDARD_DIRECTORY, PVS_JAVA_GLOBAL_JSON_FILE_NAME_WITH_EXTENSION);
    }

    @FunctionalInterface
    private static interface GlobalAndLocalConfigMergeStrategy {
        public void merge(Field var1, Field var2, Object var3, Object var4) throws IllegalAccessException, NoSuchFieldException;
    }

    private static final class LaunchModeConverter
    implements CommandLine.ITypeConverter<LaunchMode> {
        private LaunchModeConverter() {
        }

        public LaunchMode convert(String s) {
            try {
                return LaunchMode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return LaunchMode.CORE;
            }
        }
    }

    public static enum LaunchMode {
        CORE,
        GRADLE,
        MAVEN,
        IDEA,
        VSCODE;


        public String toString() {
            return this.name();
        }
    }

    private static final class WarningGroupConverter
    implements CommandLine.ITypeConverter<WarningGroup> {
        private WarningGroupConverter() {
        }

        public WarningGroup convert(String s) {
            try {
                return WarningGroup.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return WarningGroup.UNKNOWN;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExcludeFromSerialization {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NeedMakeAbsolutePath {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BooleanFlagDefaultValue {
        public boolean value();
    }
}

