/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.GradleTaskParametersProvider;
import com.pvsstudio.JsonModule;
import com.pvsstudio.JsonProject;
import com.pvsstudio.MavenGradlePluginAnalyzeTaskConverter;
import com.pvsstudio.MavenGradlePluginTask;
import com.pvsstudio.PvsGradleTask;
import com.pvsstudio.PvsStudioException;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

public class AnalyzeTask
extends PvsGradleTask
implements MavenGradlePluginTask {
    public static final String TASK_NAME = "pvsAnalyze";

    @Override
    @NotNull
    public String taskName() {
        return TASK_NAME;
    }

    @Override
    @NotNull
    public JsonProject jsonProject() {
        JsonProject jsonProject = new JsonProject();
        for (Project p : this.getProject().getAllprojects()) {
            String additionalSources;
            SourceSetContainer sourceSetContainer;
            HashSet<File> sources = new HashSet<File>();
            HashSet testSources = new HashSet();
            HashSet classpath = new HashSet();
            if (p.hasProperty("sourceSets") && (sourceSetContainer = (SourceSetContainer)p.property("sourceSets")) != null) {
                for (SourceSet sourceSet : sourceSetContainer) {
                    sources.addAll(sourceSet.getAllJava().getFiles());
                    if (Objects.equals(sourceSet.getName(), "test")) {
                        testSources.addAll(sourceSet.getAllJava().getFiles());
                    }
                    classpath.addAll(sourceSet.getCompileClasspath().getFiles());
                }
            }
            if (p.hasProperty("android")) {
                try {
                    Object android = p.property("android");
                    if (android != null) {
                        Method methodGetSourceSets = android.getClass().getDeclaredMethod("getSourceSets", new Class[0]);
                        methodGetSourceSets.setAccessible(true);
                        Object container = methodGetSourceSets.invoke(android, new Object[0]);
                        if (container instanceof NamedDomainObjectContainer) {
                            Object name22;
                            NamedDomainObjectContainer factory = (NamedDomainObjectContainer)container;
                            for (Object name22 : factory.getNames()) {
                                Set tmpSet;
                                Object androidSourceSets = factory.getAt((String)name22);
                                Method methodGetJavaDirs = androidSourceSets.getClass().getDeclaredMethod("getJavaDirectories", new Class[0]);
                                methodGetJavaDirs.setAccessible(true);
                                Object set = methodGetJavaDirs.invoke(androidSourceSets, new Object[0]);
                                if (!(set instanceof Set) || (tmpSet = (Set)set).isEmpty() || !(tmpSet.iterator().next() instanceof File)) continue;
                                sources.addAll((Set)set);
                            }
                            List classpathNames = p.getConfigurations().getNames().stream().filter(name -> name.endsWith("CompileClasspath")).collect(Collectors.toList());
                            name22 = classpathNames.iterator();
                            while (name22.hasNext()) {
                                String name3 = (String)name22.next();
                                classpath.addAll(p.getConfigurations().getByName(name3).getFiles());
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    this.printExampleMessageAndSetTaskException(new PvsStudioException("Error when retrieving information about projects", ex));
                }
            }
            if (p.hasProperty("pvsStudioAdditionalSources") && (additionalSources = (String)p.property("pvsStudioAdditionalSources")) != null) {
                String[] elements;
                for (String e : elements = additionalSources.split(",")) {
                    String path = e.trim();
                    File pathFile = new File(path);
                    if (pathFile.isAbsolute()) {
                        sources.add(pathFile);
                        continue;
                    }
                    pathFile = new File(p.getProjectDir().getAbsolutePath(), path);
                    sources.add(pathFile.getAbsoluteFile());
                }
            }
            Path buildDir = p.getBuildDir().toPath();
            Set<String> generatedSources = sources.stream().map(File::toPath).map(Path::toAbsolutePath).filter(it -> it.startsWith(buildDir)).map(Path::toString).collect(Collectors.toSet());
            jsonProject.modules.add(new JsonModule(p.getName(), p.getProjectDir().getAbsolutePath(), sources.stream().map(File::getAbsolutePath).collect(Collectors.toSet()), testSources.stream().map(File::getAbsolutePath).collect(Collectors.toSet()), classpath.stream().map(File::getAbsolutePath).collect(Collectors.toSet()), generatedSources));
        }
        return jsonProject;
    }

    @Override
    @NotNull
    public AnalyzerConfig configFromBuildSystemScript() {
        return (AnalyzerConfig)this.getProject().getExtensions().getByType(AnalyzerConfig.class);
    }

    @Override
    @NotNull
    public MavenGradlePluginAnalyzeTaskConverter taskParameterConverter() {
        return new MavenGradlePluginAnalyzeTaskConverter(new GradleTaskParametersProvider(this.getProject()));
    }

    @TaskAction
    void run() {
        this.getProject().evaluationDependsOnChildren();
        this.executeTask();
    }
}

