/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite;

import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.Checks;
import java.util.Collections;
import java.util.Set;

public final class Changes {
    @NonNull
    private final Set<String> affectedTables;

    private Changes(@NonNull Set<String> affectedTables) {
        Checks.checkNotNull(affectedTables, (String)"Please specify affected tables");
        this.affectedTables = Collections.unmodifiableSet(affectedTables);
    }

    @NonNull
    public static Changes newInstance(@NonNull Set<String> affectedTables) {
        return new Changes(affectedTables);
    }

    @NonNull
    public static Changes newInstance(@NonNull String affectedTable) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new Changes(Collections.singleton(affectedTable));
    }

    @NonNull
    public Set<String> affectedTables() {
        return this.affectedTables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changes changes = (Changes)o;
        return this.affectedTables.equals(changes.affectedTables);
    }

    public int hashCode() {
        return this.affectedTables.hashCode();
    }

    public String toString() {
        return "Changes{affectedTables=" + this.affectedTables + '}';
    }
}

