/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.List;

public final class Query {
    private final boolean distinct;
    @NonNull
    private final String table;
    @NonNull
    private final List<String> columns;
    @NonNull
    private final String where;
    @NonNull
    private final List<String> whereArgs;
    @NonNull
    private final String groupBy;
    @NonNull
    private final String having;
    @NonNull
    private final String orderBy;
    @NonNull
    private final String limit;

    private Query(boolean distinct, @NonNull String table, @Nullable List<String> columns, @Nullable String where, @Nullable List<String> whereArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        this.distinct = distinct;
        this.table = table;
        this.columns = InternalQueries.unmodifiableNonNullListOfStrings(columns);
        this.where = InternalQueries.nonNullString((String)where);
        this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
        this.groupBy = InternalQueries.nonNullString((String)groupBy);
        this.having = InternalQueries.nonNullString((String)having);
        this.orderBy = InternalQueries.nonNullString((String)orderBy);
        this.limit = InternalQueries.nonNullString((String)limit);
    }

    public boolean distinct() {
        return this.distinct;
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @NonNull
    public List<String> columns() {
        return this.columns;
    }

    @NonNull
    public String where() {
        return this.where;
    }

    @NonNull
    public List<String> whereArgs() {
        return this.whereArgs;
    }

    @NonNull
    public String groupBy() {
        return this.groupBy;
    }

    @NonNull
    public String having() {
        return this.having;
    }

    @NonNull
    public String orderBy() {
        return this.orderBy;
    }

    @NonNull
    public String limit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.distinct != query.distinct) {
            return false;
        }
        if (!this.table.equals(query.table)) {
            return false;
        }
        if (!this.columns.equals(query.columns)) {
            return false;
        }
        if (!this.where.equals(query.where)) {
            return false;
        }
        if (!this.whereArgs.equals(query.whereArgs)) {
            return false;
        }
        if (!this.groupBy.equals(query.groupBy)) {
            return false;
        }
        if (!this.having.equals(query.having)) {
            return false;
        }
        if (!this.orderBy.equals(query.orderBy)) {
            return false;
        }
        return this.limit.equals(query.limit);
    }

    public int hashCode() {
        int result = this.distinct ? 1 : 0;
        result = 31 * result + this.table.hashCode();
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + this.where.hashCode();
        result = 31 * result + this.whereArgs.hashCode();
        result = 31 * result + this.groupBy.hashCode();
        result = 31 * result + this.having.hashCode();
        result = 31 * result + this.orderBy.hashCode();
        result = 31 * result + this.limit.hashCode();
        return result;
    }

    public String toString() {
        return "Query{distinct=" + this.distinct + ", table='" + this.table + '\'' + ", columns=" + this.columns + ", where='" + this.where + '\'' + ", whereArgs=" + this.whereArgs + ", groupBy='" + this.groupBy + '\'' + ", having='" + this.having + '\'' + ", orderBy='" + this.orderBy + '\'' + ", limit='" + this.limit + '\'' + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private final String table;
        private boolean distinct;
        private List<String> columns;
        private String where;
        private List<String> whereArgs;
        private String groupBy;
        private String having;
        private String orderBy;
        private String limit;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        @NonNull
        public CompleteBuilder distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @NonNull
        public CompleteBuilder columns(String ... columns) {
            this.columns = InternalQueries.unmodifiableNonNullListOfStrings((Object[])columns);
            return this;
        }

        @NonNull
        public CompleteBuilder where(@Nullable String where) {
            this.where = where;
            return this;
        }

        @NonNull
        public CompleteBuilder whereArgs(Object ... whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings((Object[])whereArgs);
            return this;
        }

        @NonNull
        public CompleteBuilder whereArgs(@Nullable List<?> whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
            return this;
        }

        @NonNull
        public CompleteBuilder groupBy(@Nullable String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @NonNull
        public CompleteBuilder having(@Nullable String having) {
            this.having = having;
            return this;
        }

        @NonNull
        public CompleteBuilder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @NonNull
        public CompleteBuilder limit(@Nullable String limit) {
            this.limit = limit;
            return this;
        }

        @NonNull
        public Query build() {
            if (this.where == null && this.whereArgs != null && !this.whereArgs.isEmpty()) {
                throw new IllegalStateException("You can not use whereArgs without where clause");
            }
            return new Query(this.distinct, this.table, this.columns, this.where, this.whereArgs, this.groupBy, this.having, this.orderBy, this.limit);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

