/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class PutResult {
    @Nullable
    private final Long insertedId;
    @Nullable
    private final Integer numberOfRowsUpdated;
    @NonNull
    private final Set<String> affectedTables;
    @NonNull
    private final Set<String> affectedTags;

    private PutResult(@Nullable Long insertedId, @Nullable Integer numberOfRowsUpdated, @NonNull Set<String> affectedTables, @NonNull Set<String> affectedTags) {
        if (numberOfRowsUpdated != null && numberOfRowsUpdated < 0) {
            throw new IllegalArgumentException("Number of rows updated must be >= 0, but was: " + numberOfRowsUpdated);
        }
        Checks.checkNotNull(affectedTables, (String)"affectedTables must not be null");
        if (affectedTables.size() < 1) {
            throw new IllegalArgumentException("affectedTables must contain at least one element");
        }
        for (String table : affectedTables) {
            Checks.checkNotEmpty((String)table, (String)("affectedTable must not be null or empty, affectedTables = " + affectedTables));
        }
        for (String tag : affectedTags) {
            Checks.checkNotEmpty((String)tag, (String)("affectedTag must not be null or empty, affectedTags = " + affectedTags));
        }
        this.insertedId = insertedId;
        this.numberOfRowsUpdated = numberOfRowsUpdated;
        this.affectedTables = Collections.unmodifiableSet(affectedTables);
        this.affectedTags = Collections.unmodifiableSet(affectedTags);
    }

    @NonNull
    public static PutResult newInsertResult(long insertedId, @NonNull Set<String> affectedTables, @Nullable Collection<String> affectedTags) {
        return new PutResult(insertedId, null, affectedTables, InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static PutResult newInsertResult(long insertedId, @NonNull Set<String> affectedTables, String ... affectedTags) {
        return PutResult.newInsertResult(insertedId, affectedTables, (Collection<String>)InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public static PutResult newInsertResult(long insertedId, @NonNull String affectedTable, @Nullable Collection<String> affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new PutResult(insertedId, null, Collections.singleton(affectedTable), InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static PutResult newInsertResult(long insertedId, @NonNull String affectedTable, String ... affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return PutResult.newInsertResult(insertedId, Collections.singleton(affectedTable), (Collection<String>)InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public static PutResult newUpdateResult(int numberOfRowsUpdated, @NonNull Set<String> affectedTables, @Nullable Collection<String> affectedTags) {
        return new PutResult(null, numberOfRowsUpdated, affectedTables, InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static PutResult newUpdateResult(int numberOfRowsUpdated, @NonNull Set<String> affectedTables, String ... affectedTags) {
        return PutResult.newUpdateResult(numberOfRowsUpdated, affectedTables, (Collection<String>)InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public static PutResult newUpdateResult(int numberOfRowsUpdated, @NonNull String affectedTable, @Nullable Collection<String> affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return PutResult.newUpdateResult(numberOfRowsUpdated, Collections.singleton(affectedTable), (Collection<String>)InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static PutResult newUpdateResult(int numberOfRowsUpdated, @NonNull String affectedTable, String ... affectedTags) {
        return PutResult.newUpdateResult(numberOfRowsUpdated, affectedTable, (Collection<String>)InternalQueries.nonNullSet((String[])affectedTags));
    }

    public boolean wasInserted() {
        return this.insertedId != null;
    }

    public boolean wasNotInserted() {
        return !this.wasInserted();
    }

    public boolean wasUpdated() {
        return this.numberOfRowsUpdated != null && this.numberOfRowsUpdated > 0;
    }

    public boolean wasNotUpdated() {
        return !this.wasUpdated();
    }

    @Nullable
    public Long insertedId() {
        return this.insertedId;
    }

    @Nullable
    public Integer numberOfRowsUpdated() {
        return this.numberOfRowsUpdated;
    }

    @NonNull
    public Set<String> affectedTables() {
        return this.affectedTables;
    }

    @NonNull
    public Set<String> affectedTags() {
        return this.affectedTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutResult putResult = (PutResult)o;
        if (this.insertedId != null ? !this.insertedId.equals(putResult.insertedId) : putResult.insertedId != null) {
            return false;
        }
        if (this.numberOfRowsUpdated != null ? !this.numberOfRowsUpdated.equals(putResult.numberOfRowsUpdated) : putResult.numberOfRowsUpdated != null) {
            return false;
        }
        if (!this.affectedTables.equals(putResult.affectedTables)) {
            return false;
        }
        return this.affectedTags.equals(putResult.affectedTags);
    }

    public int hashCode() {
        int result = this.insertedId != null ? this.insertedId.hashCode() : 0;
        result = 31 * result + (this.numberOfRowsUpdated != null ? this.numberOfRowsUpdated.hashCode() : 0);
        result = 31 * result + this.affectedTables.hashCode();
        result = 31 * result + this.affectedTags.hashCode();
        return result;
    }

    public String toString() {
        return "PutResult{insertedId=" + this.insertedId + ", numberOfRowsUpdated=" + this.numberOfRowsUpdated + ", affectedTables=" + this.affectedTables + ", affectedTags=" + this.affectedTags + '}';
    }
}

