/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.delete.DefaultDeleteResolver;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResolver;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResult;
import com.pushtorefresh.storio.sqlite.operations.delete.PreparedDelete;
import com.pushtorefresh.storio.sqlite.operations.internal.RxJavaUtils;
import com.pushtorefresh.storio.sqlite.queries.DeleteQuery;
import rx.Completable;
import rx.Observable;
import rx.Single;

public class PreparedDeleteByQuery
extends PreparedDelete<DeleteResult> {
    @NonNull
    private final DeleteQuery deleteQuery;
    @NonNull
    private final DeleteResolver<DeleteQuery> deleteResolver;

    PreparedDeleteByQuery(@NonNull StorIOSQLite storIOSQLite, @NonNull DeleteQuery deleteQuery, @NonNull DeleteResolver<DeleteQuery> deleteResolver) {
        super(storIOSQLite);
        this.deleteQuery = deleteQuery;
        this.deleteResolver = deleteResolver;
    }

    @WorkerThread
    @NonNull
    public DeleteResult executeAsBlocking() {
        try {
            DeleteResult deleteResult = this.deleteResolver.performDelete(this.storIOSQLite, this.deleteQuery);
            if (deleteResult.numberOfRowsDeleted() > 0) {
                Changes changes = Changes.newInstance(deleteResult.affectedTables(), deleteResult.affectedTags());
                this.storIOSQLite.lowLevel().notifyAboutChanges(changes);
            }
            return deleteResult;
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Delete operation. query = " + this.deleteQuery, (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<DeleteResult> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    public Observable<DeleteResult> asRxObservable() {
        return RxJavaUtils.createObservable(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Single<DeleteResult> asRxSingle() {
        return RxJavaUtils.createSingle(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Completable asRxCompletable() {
        return RxJavaUtils.createCompletable(this.storIOSQLite, this);
    }

    public static class Builder {
        private static final DeleteResolver<DeleteQuery> STANDARD_DELETE_RESOLVER = new DefaultDeleteResolver<DeleteQuery>(){

            @Override
            @NonNull
            public DeleteQuery mapToDeleteQuery(@NonNull DeleteQuery deleteQuery) {
                return deleteQuery;
            }
        };
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final DeleteQuery deleteQuery;
        private DeleteResolver<DeleteQuery> deleteResolver;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull DeleteQuery deleteQuery) {
            this.storIOSQLite = storIOSQLite;
            this.deleteQuery = deleteQuery;
        }

        @NonNull
        public Builder withDeleteResolver(@Nullable DeleteResolver<DeleteQuery> deleteResolver) {
            this.deleteResolver = deleteResolver;
            return this;
        }

        @NonNull
        public PreparedDeleteByQuery prepare() {
            if (this.deleteResolver == null) {
                this.deleteResolver = STANDARD_DELETE_RESOLVER;
            }
            return new PreparedDeleteByQuery(this.storIOSQLite, this.deleteQuery, this.deleteResolver);
        }
    }
}

