/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class DeleteResult {
    private final int numberOfRowsDeleted;
    @NonNull
    private final Set<String> affectedTables;
    @NonNull
    private final Set<String> affectedTags;

    private DeleteResult(int numberOfRowsDeleted, @NonNull Set<String> affectedTables, @NonNull Set<String> affectedTags) {
        Checks.checkNotNull(affectedTables, (String)"Please specify affected tables");
        for (String table : affectedTables) {
            Checks.checkNotEmpty((String)table, (String)("affectedTable must not be null or empty, affectedTables = " + affectedTables));
        }
        for (String tag : affectedTags) {
            Checks.checkNotEmpty((String)tag, (String)("affectedTag must not be null or empty, affectedTags = " + affectedTags));
        }
        this.numberOfRowsDeleted = numberOfRowsDeleted;
        this.affectedTables = Collections.unmodifiableSet(affectedTables);
        this.affectedTags = Collections.unmodifiableSet(affectedTags);
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull Set<String> affectedTables, @Nullable Collection<String> affectedTags) {
        return new DeleteResult(numberOfRowsDeleted, affectedTables, InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull Set<String> affectedTables, String ... affectedTags) {
        return new DeleteResult(numberOfRowsDeleted, affectedTables, InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull String affectedTable, @Nullable Collection<String> affectedTags) {
        return new DeleteResult(numberOfRowsDeleted, Collections.singleton(affectedTable), InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull String affectedTable, String ... affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new DeleteResult(numberOfRowsDeleted, Collections.singleton(affectedTable), InternalQueries.nonNullSet((String[])affectedTags));
    }

    public int numberOfRowsDeleted() {
        return this.numberOfRowsDeleted;
    }

    @NonNull
    public Set<String> affectedTables() {
        return this.affectedTables;
    }

    @NonNull
    public Set<String> affectedTags() {
        return this.affectedTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteResult that = (DeleteResult)o;
        if (this.numberOfRowsDeleted != that.numberOfRowsDeleted) {
            return false;
        }
        if (!this.affectedTables.equals(that.affectedTables)) {
            return false;
        }
        return this.affectedTags.equals(that.affectedTags);
    }

    public int hashCode() {
        int result = this.numberOfRowsDeleted;
        result = 31 * result + this.affectedTables.hashCode();
        result = 31 * result + this.affectedTags.hashCode();
        return result;
    }

    public String toString() {
        return "DeleteResult{numberOfRowsDeleted=" + this.numberOfRowsDeleted + ", affectedTables=" + this.affectedTables + ", affectedTags=" + this.affectedTags + '}';
    }
}

