/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.sqlite.Changes;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

public final class ChangesFilter
implements Func1<Changes, Boolean> {
    @Nullable
    private final Set<String> tables;
    @Nullable
    private final Set<String> tags;

    private ChangesFilter(@Nullable Set<String> tables, @Nullable Set<String> tags) {
        this.tables = tables;
        this.tags = tags;
    }

    @NonNull
    public static Observable<Changes> applyForTables(@NonNull Observable<Changes> rxBus, @NonNull Set<String> tables) {
        Checks.checkNotNull(tables, (String)"Set of tables can not be null");
        return rxBus.filter((Func1)new ChangesFilter(tables, null));
    }

    @NonNull
    public static Observable<Changes> applyForTags(@NonNull Observable<Changes> rxBus, @NonNull Set<String> tags) {
        Checks.checkNotNull(tags, (String)"Set of tags can not be null");
        return rxBus.filter((Func1)new ChangesFilter(null, tags));
    }

    @NonNull
    public static Observable<Changes> applyForTablesAndTags(@NonNull Observable<Changes> rxBus, @NonNull Set<String> tables, @NonNull Set<String> tags) {
        Checks.checkNotNull(tables, (String)"Set of tables can not be null");
        Checks.checkNotNull(tags, (String)"Set of tags can not be null");
        return rxBus.filter((Func1)new ChangesFilter(tables, tags));
    }

    @NonNull
    public Boolean call(@NonNull Changes changes) {
        if (this.tables != null) {
            for (String affectedTable : changes.affectedTables()) {
                if (!this.tables.contains(affectedTable)) continue;
                return true;
            }
        }
        if (this.tags != null) {
            for (String affectedTag : changes.affectedTags()) {
                if (!this.tags.contains(affectedTag)) continue;
                return true;
            }
        }
        return false;
    }
}

