/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RawQuery {
    @NonNull
    private final String query;
    @NonNull
    private final List<Object> args;
    @NonNull
    private final Set<String> affectsTables;
    @NonNull
    private final Set<String> affectsTags;
    @NonNull
    private final Set<String> observesTables;
    @NonNull
    private final Set<String> observesTags;

    private RawQuery(@NonNull String query, @Nullable List<Object> args, @Nullable Set<String> affectsTables, @Nullable Set<String> affectsTags, @Nullable Set<String> observesTables, @Nullable Set<String> observesTags) {
        if (affectsTags != null) {
            for (String tag : affectsTags) {
                Checks.checkNotEmpty((String)tag, (String)("affectsTag must not be null or empty, affectsTags = " + affectsTags));
            }
        }
        if (observesTags != null) {
            for (String tag : observesTags) {
                Checks.checkNotEmpty((String)tag, (String)("observesTag must not be null or empty, observesTags = " + observesTags));
            }
        }
        this.query = query;
        this.args = InternalQueries.unmodifiableNonNullList(args);
        this.affectsTables = InternalQueries.unmodifiableNonNullSet(affectsTables);
        this.affectsTags = InternalQueries.unmodifiableNonNullSet(affectsTags);
        this.observesTables = InternalQueries.unmodifiableNonNullSet(observesTables);
        this.observesTags = InternalQueries.unmodifiableNonNullSet(observesTags);
    }

    @NonNull
    public String query() {
        return this.query;
    }

    @NonNull
    public List<Object> args() {
        return this.args;
    }

    @NonNull
    public Set<String> affectsTables() {
        return this.affectsTables;
    }

    @NonNull
    public Set<String> affectsTags() {
        return this.affectsTags;
    }

    @NonNull
    public Set<String> observesTables() {
        return this.observesTables;
    }

    @NonNull
    public Set<String> observesTags() {
        return this.observesTags;
    }

    @NonNull
    public CompleteBuilder toBuilder() {
        return new CompleteBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawQuery rawQuery = (RawQuery)o;
        if (!this.query.equals(rawQuery.query)) {
            return false;
        }
        if (!this.args.equals(rawQuery.args)) {
            return false;
        }
        if (!this.affectsTables.equals(rawQuery.affectsTables)) {
            return false;
        }
        if (!this.affectsTags.equals(rawQuery.affectsTags)) {
            return false;
        }
        if (!this.observesTables.equals(rawQuery.observesTables)) {
            return false;
        }
        return this.observesTags.equals(rawQuery.observesTags);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.args.hashCode();
        result = 31 * result + this.affectsTables.hashCode();
        result = 31 * result + this.affectsTags.hashCode();
        result = 31 * result + this.observesTables.hashCode();
        result = 31 * result + this.observesTags.hashCode();
        return result;
    }

    public String toString() {
        return "RawQuery{query='" + this.query + '\'' + ", args=" + this.args + ", affectsTables=" + this.affectsTables + ", affectsTags=" + this.affectsTags + ", observesTables=" + this.observesTables + ", observesTags=" + this.observesTags + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class CompleteBuilder {
        @NonNull
        private String query;
        private List<Object> args;
        private Set<String> affectsTables;
        private Set<String> affectsTags;
        private Set<String> observesTables;
        private Set<String> observesTags;

        CompleteBuilder(@NonNull String query) {
            this.query = query;
        }

        CompleteBuilder(@NonNull RawQuery rawQuery) {
            this.query = rawQuery.query;
            this.args = rawQuery.args;
            this.affectsTables = rawQuery.affectsTables;
            this.affectsTags = rawQuery.affectsTags;
            this.observesTables = rawQuery.observesTables;
            this.observesTags = rawQuery.observesTags;
        }

        @NonNull
        public CompleteBuilder query(@NonNull String query) {
            Checks.checkNotEmpty((String)query, (String)"Query is null or empty");
            this.query = query;
            return this;
        }

        @NonNull
        public <T> CompleteBuilder args(T ... args) {
            this.args = InternalQueries.unmodifiableNonNullList((Object[])args);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTables(String ... tables) {
            if (this.affectsTables == null) {
                this.affectsTables = new HashSet<String>(tables.length);
            } else {
                this.affectsTables.clear();
            }
            Collections.addAll(this.affectsTables, tables);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTables(@NonNull Collection<String> tables) {
            if (this.affectsTables == null) {
                this.affectsTables = new HashSet<String>(tables.size());
            } else {
                this.affectsTables.clear();
            }
            this.affectsTables.addAll(tables);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@NonNull String tag, String ... tags) {
            this.affectsTags = InternalQueries.nonNullSet((String)tag, (String[])tags);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@Nullable Collection<String> tags) {
            this.affectsTags = InternalQueries.nonNullSet(tags);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTables(String ... tables) {
            if (this.observesTables == null) {
                this.observesTables = new HashSet<String>(tables.length);
            } else {
                this.observesTables.clear();
            }
            Collections.addAll(this.observesTables, tables);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTables(@NonNull Collection<String> tables) {
            if (this.observesTables == null) {
                this.observesTables = new HashSet<String>(tables.size());
            } else {
                this.observesTables.clear();
            }
            this.observesTables.addAll(tables);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTags(@NonNull String tag, String ... tags) {
            this.observesTags = InternalQueries.nonNullSet((String)tag, (String[])tags);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTags(@Nullable Collection<String> tags) {
            this.observesTags = InternalQueries.nonNullSet(tags);
            return this;
        }

        @NonNull
        public RawQuery build() {
            return new RawQuery(this.query, this.args, this.affectsTables, this.affectsTags, this.observesTables, this.observesTags);
        }
    }

    public static class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder query(@NonNull String query) {
            Checks.checkNotEmpty((String)query, (String)"Query is null or empty");
            return new CompleteBuilder(query);
        }
    }
}

