/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.get;

import android.database.Cursor;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.MapSomethingToExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.impl.ChangesFilter;
import com.pushtorefresh.storio.sqlite.operations.get.DefaultGetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.GetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.PreparedGet;
import com.pushtorefresh.storio.sqlite.operations.internal.RxJavaUtils;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import java.util.Collections;
import java.util.Set;
import rx.Observable;
import rx.Single;

public class PreparedGetCursor
extends PreparedGet<Cursor> {
    @NonNull
    private final GetResolver<Cursor> getResolver;

    PreparedGetCursor(@NonNull StorIOSQLite storIOSQLite, @NonNull Query query, @NonNull GetResolver<Cursor> getResolver) {
        super(storIOSQLite, query);
        this.getResolver = getResolver;
    }

    PreparedGetCursor(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery, @NonNull GetResolver<Cursor> getResolver) {
        super(storIOSQLite, rawQuery);
        this.getResolver = getResolver;
    }

    @WorkerThread
    @NonNull
    public Cursor executeAsBlocking() {
        try {
            if (this.query != null) {
                return this.getResolver.performGet(this.storIOSQLite, this.query);
            }
            if (this.rawQuery != null) {
                return this.getResolver.performGet(this.storIOSQLite, this.rawQuery);
            }
            throw new IllegalStateException("Please specify query");
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Get operation. query = " + (this.query != null ? this.query : this.rawQuery), (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<Cursor> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<Cursor> asRxObservable() {
        Set<String> tags;
        Set<String> tables;
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        if (this.query != null) {
            tables = Collections.singleton(this.query.table());
            tags = this.query.observesTags();
        } else if (this.rawQuery != null) {
            tables = this.rawQuery.observesTables();
            tags = this.rawQuery.observesTags();
        } else {
            throw new StorIOException("Please specify query");
        }
        Observable observable = !tables.isEmpty() || !tags.isEmpty() ? ChangesFilter.applyForTablesAndTags(this.storIOSQLite.observeChanges(), tables, tags).map(MapSomethingToExecuteAsBlocking.newInstance((PreparedOperation)this)).startWith(Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this))).onBackpressureLatest() : Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this));
        return RxJavaUtils.subscribeOn(this.storIOSQLite, observable);
    }

    @NonNull
    @CheckResult
    public Single<Cursor> asRxSingle() {
        return RxJavaUtils.createSingle(this.storIOSQLite, this);
    }

    public static class CompleteBuilder {
        @NonNull
        static final GetResolver<Cursor> STANDARD_GET_RESOLVER = new DefaultGetResolver<Cursor>(){

            @Override
            @NonNull
            public Cursor mapFromCursor(@NonNull Cursor cursor) {
                return cursor;
            }
        };
        @NonNull
        private final StorIOSQLite storIOSQLite;
        Query query;
        RawQuery rawQuery;
        private GetResolver<Cursor> getResolver;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Query query) {
            this.storIOSQLite = storIOSQLite;
            this.query = query;
            this.rawQuery = null;
        }

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery) {
            this.storIOSQLite = storIOSQLite;
            this.rawQuery = rawQuery;
            this.query = null;
        }

        @NonNull
        public CompleteBuilder withGetResolver(@Nullable GetResolver<Cursor> getResolver) {
            this.getResolver = getResolver;
            return this;
        }

        @NonNull
        public PreparedGetCursor prepare() {
            if (this.getResolver == null) {
                this.getResolver = STANDARD_GET_RESOLVER;
            }
            if (this.query != null) {
                return new PreparedGetCursor(this.storIOSQLite, this.query, this.getResolver);
            }
            if (this.rawQuery != null) {
                return new PreparedGetCursor(this.storIOSQLite, this.rawQuery, this.getResolver);
            }
            throw new IllegalStateException("Please specify query");
        }
    }

    public static class Builder {
        @NonNull
        private final StorIOSQLite storIOSQLite;

        Builder(@NonNull StorIOSQLite storIOSQLite) {
            this.storIOSQLite = storIOSQLite;
        }

        @NonNull
        public CompleteBuilder withQuery(@NonNull Query query) {
            Checks.checkNotNull((Object)query, (String)"Please specify query");
            return new CompleteBuilder(this.storIOSQLite, query);
        }

        @NonNull
        public CompleteBuilder withQuery(@NonNull RawQuery rawQuery) {
            Checks.checkNotNull((Object)rawQuery, (String)"Please specify rawQuery");
            return new CompleteBuilder(this.storIOSQLite, rawQuery);
        }
    }
}

