/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.internal;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlockingCompletable;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlockingSingle;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;

public final class RxJavaUtils {
    private RxJavaUtils() {
        throw new IllegalStateException("No instances please.");
    }

    @CheckResult
    @NonNull
    public static <T> Observable<T> createObservable(@NonNull StorIOSQLite storIOSQLite, @NonNull PreparedOperation<T> operation) {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        Observable observable = Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance(operation));
        return RxJavaUtils.subscribeOn(storIOSQLite, observable);
    }

    @CheckResult
    @NonNull
    public static <T> Single<T> createSingle(@NonNull StorIOSQLite storIOSQLite, @NonNull PreparedOperation<T> operation) {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxSingle()");
        Single single = Single.create((Single.OnSubscribe)OnSubscribeExecuteAsBlockingSingle.newInstance(operation));
        return RxJavaUtils.subscribeOn(storIOSQLite, single);
    }

    @CheckResult
    @NonNull
    public static <T> Completable createCompletable(@NonNull StorIOSQLite storIOSQLite, @NonNull PreparedOperation<T> operation) {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxCompletable()");
        Completable completable = Completable.create((Completable.OnSubscribe)OnSubscribeExecuteAsBlockingCompletable.newInstance(operation));
        return RxJavaUtils.subscribeOn(storIOSQLite, completable);
    }

    @CheckResult
    @NonNull
    public static <T> Observable<T> subscribeOn(@NonNull StorIOSQLite storIOSQLite, @NonNull Observable<T> observable) {
        Scheduler scheduler = storIOSQLite.defaultScheduler();
        return scheduler != null ? observable.subscribeOn(scheduler) : observable;
    }

    @CheckResult
    @NonNull
    public static <T> Single<T> subscribeOn(@NonNull StorIOSQLite storIOSQLite, @NonNull Single<T> single) {
        Scheduler scheduler = storIOSQLite.defaultScheduler();
        return scheduler != null ? single.subscribeOn(scheduler) : single;
    }

    @CheckResult
    @NonNull
    public static Completable subscribeOn(@NonNull StorIOSQLite storIOSQLite, @NonNull Completable completable) {
        Scheduler scheduler = storIOSQLite.defaultScheduler();
        return scheduler != null ? completable.subscribeOn(scheduler) : completable;
    }
}

