/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResult;
import java.util.Collections;
import java.util.Map;

public final class DeleteResults<T> {
    @NonNull
    private final Map<T, DeleteResult> results;

    private DeleteResults(@NonNull Map<T, DeleteResult> results) {
        Checks.checkNotNull(results, (String)"Please specify Delete Operation results");
        this.results = Collections.unmodifiableMap(results);
    }

    @NonNull
    public static <T> DeleteResults<T> newInstance(@NonNull Map<T, DeleteResult> results) {
        return new DeleteResults<T>(results);
    }

    @NonNull
    public Map<T, DeleteResult> results() {
        return this.results;
    }

    public boolean wasDeleted(@NonNull T object) {
        DeleteResult result = this.results.get(object);
        return result != null && result.numberOfRowsDeleted() > 0;
    }

    public boolean wasNotDeleted(@NonNull T object) {
        return !this.wasDeleted(object);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteResults that = (DeleteResults)o;
        return this.results.equals(that.results);
    }

    public int hashCode() {
        return this.results.hashCode();
    }

    public String toString() {
        return "DeleteResults{results=" + this.results + '}';
    }
}

