/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite;

import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.TypeMapping;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResolver;
import com.pushtorefresh.storio.sqlite.operations.get.GetResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;

public class SQLiteTypeMapping<T>
implements TypeMapping<T> {
    @NonNull
    private final PutResolver<T> putResolver;
    @NonNull
    private final GetResolver<T> getResolver;
    @NonNull
    private final DeleteResolver<T> deleteResolver;

    protected SQLiteTypeMapping(@NonNull PutResolver<T> putResolver, @NonNull GetResolver<T> getResolver, @NonNull DeleteResolver<T> deleteResolver) {
        this.putResolver = putResolver;
        this.getResolver = getResolver;
        this.deleteResolver = deleteResolver;
    }

    @NonNull
    public PutResolver<T> putResolver() {
        return this.putResolver;
    }

    @NonNull
    public GetResolver<T> getResolver() {
        return this.getResolver;
    }

    @NonNull
    public DeleteResolver<T> deleteResolver() {
        return this.deleteResolver;
    }

    @NonNull
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class CompleteBuilder<T> {
        @NonNull
        private final PutResolver<T> putResolver;
        @NonNull
        private final GetResolver<T> getResolver;
        @NonNull
        private final DeleteResolver<T> deleteResolver;

        CompleteBuilder(@NonNull PutResolver<T> putResolver, @NonNull GetResolver<T> getResolver, @NonNull DeleteResolver<T> deleteResolver) {
            this.putResolver = putResolver;
            this.getResolver = getResolver;
            this.deleteResolver = deleteResolver;
        }

        @NonNull
        public SQLiteTypeMapping<T> build() {
            return new SQLiteTypeMapping<T>(this.putResolver, this.getResolver, this.deleteResolver);
        }
    }

    public static final class GetResolverBuilder<T> {
        @NonNull
        private final PutResolver<T> putResolver;
        @NonNull
        private final GetResolver<T> getResolver;

        GetResolverBuilder(@NonNull PutResolver<T> putResolver, @NonNull GetResolver<T> getResolver) {
            this.putResolver = putResolver;
            this.getResolver = getResolver;
        }

        @NonNull
        public CompleteBuilder<T> deleteResolver(@NonNull DeleteResolver<T> deleteResolver) {
            Checks.checkNotNull(deleteResolver, (String)"Please specify DeleteResolver");
            return new CompleteBuilder<T>(this.putResolver, this.getResolver, deleteResolver);
        }
    }

    public static final class PutResolverBuilder<T> {
        @NonNull
        private final PutResolver<T> putResolver;

        PutResolverBuilder(@NonNull PutResolver<T> putResolver) {
            this.putResolver = putResolver;
        }

        @NonNull
        public GetResolverBuilder<T> getResolver(@NonNull GetResolver<T> getResolver) {
            Checks.checkNotNull(getResolver, (String)"Please specify GetResolver");
            return new GetResolverBuilder<T>(this.putResolver, getResolver);
        }
    }

    public static final class Builder<T> {
        Builder() {
        }

        @NonNull
        public PutResolverBuilder<T> putResolver(@NonNull PutResolver<T> putResolver) {
            Checks.checkNotNull(putResolver, (String)"Please specify PutResolver");
            return new PutResolverBuilder<T>(putResolver);
        }
    }
}

