/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.impl;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.TypeMappingFinder;
import com.pushtorefresh.storio.internal.ChangesBus;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.internal.InternalQueries;
import com.pushtorefresh.storio.internal.TypeMappingFinderImpl;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.impl.ChangesFilter;
import com.pushtorefresh.storio.sqlite.queries.DeleteQuery;
import com.pushtorefresh.storio.sqlite.queries.InsertQuery;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import com.pushtorefresh.storio.sqlite.queries.UpdateQuery;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class DefaultStorIOSQLite
extends StorIOSQLite {
    @NonNull
    private final SQLiteOpenHelper sqLiteOpenHelper;
    @NonNull
    private final ChangesBus<Changes> changesBus = new ChangesBus(Environment.RX_JAVA_IS_IN_THE_CLASS_PATH);
    @Nullable
    private final Scheduler defaultScheduler;
    @NonNull
    private final StorIOSQLite.Internal lowLevel;

    protected DefaultStorIOSQLite(@NonNull SQLiteOpenHelper sqLiteOpenHelper, @NonNull TypeMappingFinder typeMappingFinder, @Nullable Scheduler defaultScheduler) {
        this.sqLiteOpenHelper = sqLiteOpenHelper;
        this.defaultScheduler = defaultScheduler;
        this.lowLevel = new LowLevelImpl(typeMappingFinder);
    }

    @Override
    @NonNull
    public Observable<Changes> observeChanges() {
        Observable rxBus = this.changesBus.asObservable();
        if (rxBus == null) {
            throw new IllegalStateException("Observing changes in StorIOSQLite requires RxJava");
        }
        return rxBus;
    }

    @Override
    @NonNull
    public Observable<Changes> observeChangesInTables(@NonNull Set<String> tables) {
        return ChangesFilter.apply(this.observeChanges(), tables);
    }

    @Override
    public Scheduler defaultScheduler() {
        return this.defaultScheduler;
    }

    @Override
    @Deprecated
    @NonNull
    public StorIOSQLite.Internal internal() {
        return this.lowLevel;
    }

    @Override
    @NonNull
    public StorIOSQLite.LowLevel lowLevel() {
        return this.lowLevel;
    }

    @Override
    public void close() throws IOException {
        this.sqLiteOpenHelper.close();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    protected class InternalImpl
    extends LowLevelImpl {
        protected InternalImpl(TypeMappingFinder typeMappingFinder) {
            super(typeMappingFinder);
        }
    }

    protected class LowLevelImpl
    extends StorIOSQLite.Internal {
        @NonNull
        private final Object lock = new Object();
        @NonNull
        private final TypeMappingFinder typeMappingFinder;
        @NonNull
        private AtomicInteger numberOfRunningTransactions = new AtomicInteger(0);
        @NonNull
        private Set<Changes> pendingChanges = new HashSet<Changes>(5);

        protected LowLevelImpl(TypeMappingFinder typeMappingFinder) {
            this.typeMappingFinder = typeMappingFinder;
        }

        @Override
        @Nullable
        public <T> SQLiteTypeMapping<T> typeMapping(@NonNull Class<T> type) {
            return (SQLiteTypeMapping)this.typeMappingFinder.findTypeMapping(type);
        }

        @Override
        @WorkerThread
        public void executeSQL(@NonNull RawQuery rawQuery) {
            if (rawQuery.args().isEmpty()) {
                DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().execSQL(rawQuery.query());
            } else {
                DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().execSQL(rawQuery.query(), rawQuery.args().toArray(new Object[rawQuery.args().size()]));
            }
        }

        @Override
        @WorkerThread
        @NonNull
        public Cursor rawQuery(@NonNull RawQuery rawQuery) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getReadableDatabase().rawQuery(rawQuery.query(), InternalQueries.nullableArrayOfStrings(rawQuery.args()));
        }

        @Override
        @WorkerThread
        @NonNull
        public Cursor query(@NonNull Query query) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getReadableDatabase().query(query.distinct(), query.table(), InternalQueries.nullableArrayOfStringsFromListOfStrings(query.columns()), InternalQueries.nullableString((String)query.where()), InternalQueries.nullableArrayOfStringsFromListOfStrings(query.whereArgs()), InternalQueries.nullableString((String)query.groupBy()), InternalQueries.nullableString((String)query.having()), InternalQueries.nullableString((String)query.orderBy()), InternalQueries.nullableString((String)query.limit()));
        }

        @Override
        @WorkerThread
        public long insert(@NonNull InsertQuery insertQuery, @NonNull ContentValues contentValues) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().insertOrThrow(insertQuery.table(), insertQuery.nullColumnHack(), contentValues);
        }

        @Override
        @WorkerThread
        public long insertWithOnConflict(@NonNull InsertQuery insertQuery, @NonNull ContentValues contentValues, int conflictAlgorithm) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().insertWithOnConflict(insertQuery.table(), insertQuery.nullColumnHack(), contentValues, conflictAlgorithm);
        }

        @Override
        @WorkerThread
        public int update(@NonNull UpdateQuery updateQuery, @NonNull ContentValues contentValues) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().update(updateQuery.table(), contentValues, InternalQueries.nullableString((String)updateQuery.where()), InternalQueries.nullableArrayOfStringsFromListOfStrings(updateQuery.whereArgs()));
        }

        @Override
        @WorkerThread
        public int delete(@NonNull DeleteQuery deleteQuery) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().delete(deleteQuery.table(), InternalQueries.nullableString((String)deleteQuery.where()), InternalQueries.nullableArrayOfStringsFromListOfStrings(deleteQuery.whereArgs()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAboutChanges(@NonNull Changes changes) {
            Checks.checkNotNull((Object)changes, (String)"Changes can not be null");
            if (this.numberOfRunningTransactions.get() == 0) {
                DefaultStorIOSQLite.this.changesBus.onNext((Object)changes);
            } else {
                Object object = this.lock;
                synchronized (object) {
                    this.pendingChanges.add(changes);
                }
                this.notifyAboutPendingChangesIfNotInTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAboutPendingChangesIfNotInTransaction() {
            Set<Changes> changesToSend;
            if (this.numberOfRunningTransactions.get() == 0) {
                Object object = this.lock;
                synchronized (object) {
                    changesToSend = this.pendingChanges;
                    this.pendingChanges = new HashSet<Changes>(5);
                }
            } else {
                changesToSend = null;
            }
            if (changesToSend != null && changesToSend.size() > 0) {
                HashSet<String> affectedTables = new HashSet<String>(3);
                for (Changes changes : changesToSend) {
                    affectedTables.addAll(changes.affectedTables());
                }
                DefaultStorIOSQLite.this.changesBus.onNext((Object)Changes.newInstance(affectedTables));
            }
        }

        @Override
        public void beginTransaction() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().beginTransaction();
            this.numberOfRunningTransactions.incrementAndGet();
        }

        @Override
        public void setTransactionSuccessful() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().setTransactionSuccessful();
        }

        @Override
        public void endTransaction() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().endTransaction();
            this.numberOfRunningTransactions.decrementAndGet();
            this.notifyAboutPendingChangesIfNotInTransaction();
        }
    }

    public static final class CompleteBuilder {
        @NonNull
        private final SQLiteOpenHelper sqLiteOpenHelper;
        private Map<Class<?>, SQLiteTypeMapping<?>> typeMapping;
        @Nullable
        private TypeMappingFinder typeMappingFinder;
        @Nullable
        private Scheduler defaultScheduler = Environment.RX_JAVA_IS_IN_THE_CLASS_PATH ? Schedulers.io() : null;

        CompleteBuilder(@NonNull SQLiteOpenHelper sqLiteOpenHelper) {
            this.sqLiteOpenHelper = sqLiteOpenHelper;
        }

        @NonNull
        public <T> CompleteBuilder addTypeMapping(@NonNull Class<T> type, @NonNull SQLiteTypeMapping<T> typeMapping) {
            Checks.checkNotNull(type, (String)"Please specify type");
            Checks.checkNotNull(typeMapping, (String)"Please specify type mapping");
            if (this.typeMapping == null) {
                this.typeMapping = new HashMap();
            }
            this.typeMapping.put(type, typeMapping);
            return this;
        }

        @NonNull
        public CompleteBuilder typeMappingFinder(@NonNull TypeMappingFinder typeMappingFinder) {
            Checks.checkNotNull((Object)typeMappingFinder, (String)"Please specify typeMappingFinder");
            this.typeMappingFinder = typeMappingFinder;
            return this;
        }

        @NonNull
        public CompleteBuilder defaultScheduler(@Nullable Scheduler defaultScheduler) {
            this.defaultScheduler = defaultScheduler;
            return this;
        }

        @NonNull
        public DefaultStorIOSQLite build() {
            if (this.typeMappingFinder == null) {
                this.typeMappingFinder = new TypeMappingFinderImpl();
            }
            if (this.typeMapping != null) {
                this.typeMappingFinder.directTypeMapping(Collections.unmodifiableMap(this.typeMapping));
            }
            return new DefaultStorIOSQLite(this.sqLiteOpenHelper, this.typeMappingFinder, this.defaultScheduler);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder sqliteOpenHelper(@NonNull SQLiteOpenHelper sqliteOpenHelper) {
            Checks.checkNotNull((Object)sqliteOpenHelper, (String)"Please specify SQLiteOpenHelper instance");
            return new CompleteBuilder(sqliteOpenHelper);
        }
    }
}

