/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResolver;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResult;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResults;
import com.pushtorefresh.storio.sqlite.operations.delete.PreparedDelete;
import com.pushtorefresh.storio.sqlite.operations.internal.RxJavaUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import rx.Completable;
import rx.Observable;
import rx.Single;

public class PreparedDeleteCollectionOfObjects<T>
extends PreparedDelete<DeleteResults<T>> {
    @NonNull
    private final Collection<T> objects;
    @Nullable
    private final DeleteResolver<T> explicitDeleteResolver;
    private final boolean useTransaction;

    PreparedDeleteCollectionOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Collection<T> objects, @Nullable DeleteResolver<T> explicitDeleteResolver, boolean useTransaction) {
        super(storIOSQLite);
        this.objects = objects;
        this.explicitDeleteResolver = explicitDeleteResolver;
        this.useTransaction = useTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NonNull
    public DeleteResults<T> executeAsBlocking() {
        try {
            ArrayList objectsAndDeleteResolvers;
            StorIOSQLite.LowLevel lowLevel = this.storIOSQLite.lowLevel();
            if (this.explicitDeleteResolver != null) {
                objectsAndDeleteResolvers = null;
            } else {
                objectsAndDeleteResolvers = new ArrayList(this.objects.size());
                for (T object : this.objects) {
                    SQLiteTypeMapping<?> typeMapping = lowLevel.typeMapping(object.getClass());
                    if (typeMapping == null) {
                        throw new IllegalStateException("One of the objects from the collection does not have type mapping: object = " + object + ", object.class = " + object.getClass() + ",db was not affected by this operation, please add type mapping for this type");
                    }
                    objectsAndDeleteResolvers.add(new AbstractMap.SimpleImmutableEntry(object, typeMapping.deleteResolver()));
                }
            }
            if (this.useTransaction) {
                lowLevel.beginTransaction();
            }
            HashMap<Object, DeleteResult> results = new HashMap<Object, DeleteResult>(this.objects.size());
            boolean transactionSuccessful = false;
            try {
                if (this.explicitDeleteResolver != null) {
                    for (T t : this.objects) {
                        DeleteResult deleteResult = this.explicitDeleteResolver.performDelete(this.storIOSQLite, t);
                        results.put(t, deleteResult);
                        if (this.useTransaction || deleteResult.numberOfRowsDeleted() <= 0) continue;
                        lowLevel.notifyAboutChanges(Changes.newInstance(deleteResult.affectedTables()));
                    }
                } else {
                    for (AbstractMap.SimpleImmutableEntry simpleImmutableEntry : objectsAndDeleteResolvers) {
                        Object object = simpleImmutableEntry.getKey();
                        DeleteResolver deleteResolver = (DeleteResolver)simpleImmutableEntry.getValue();
                        DeleteResult deleteResult = deleteResolver.performDelete(this.storIOSQLite, object);
                        results.put(object, deleteResult);
                        if (this.useTransaction || deleteResult.numberOfRowsDeleted() <= 0) continue;
                        lowLevel.notifyAboutChanges(Changes.newInstance(deleteResult.affectedTables()));
                    }
                }
                if (this.useTransaction) {
                    lowLevel.setTransactionSuccessful();
                    transactionSuccessful = true;
                }
            }
            finally {
                if (this.useTransaction) {
                    lowLevel.endTransaction();
                    if (transactionSuccessful) {
                        HashSet<String> affectedTables = new HashSet<String>(1);
                        for (Object object : results.keySet()) {
                            DeleteResult deleteResult = (DeleteResult)results.get(object);
                            if (deleteResult.numberOfRowsDeleted() <= 0) continue;
                            affectedTables.addAll(((DeleteResult)results.get(object)).affectedTables());
                        }
                        if (!affectedTables.isEmpty()) {
                            lowLevel.notifyAboutChanges(Changes.newInstance(affectedTables));
                        }
                    }
                }
            }
            return DeleteResults.newInstance(results);
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Delete operation. objects = " + this.objects, (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<DeleteResults<T>> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<DeleteResults<T>> asRxObservable() {
        return RxJavaUtils.createObservable(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Single<DeleteResults<T>> asRxSingle() {
        return RxJavaUtils.createSingle(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Completable asRxCompletable() {
        return RxJavaUtils.createCompletable(this.storIOSQLite, this);
    }

    public static class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Collection<T> objects;
        private DeleteResolver<T> deleteResolver;
        private boolean useTransaction = true;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull Collection<T> objects) {
            this.storIOSQLite = storIOSQLite;
            this.objects = objects;
        }

        @NonNull
        public Builder<T> useTransaction(boolean useTransaction) {
            this.useTransaction = useTransaction;
            return this;
        }

        @NonNull
        public Builder<T> withDeleteResolver(@Nullable DeleteResolver<T> deleteResolver) {
            this.deleteResolver = deleteResolver;
            return this;
        }

        @NonNull
        public PreparedDeleteCollectionOfObjects<T> prepare() {
            return new PreparedDeleteCollectionOfObjects<T>(this.storIOSQLite, this.objects, this.deleteResolver, this.useTransaction);
        }
    }
}

