package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Pack;

/***
 * Base class for generating downstream messages
 */
public abstract class DownstreamMessageFactory {
    public abstract DownstreamMessage buildMessage(Pack data);

    /***
     * set message ID and delivery required flag
     *
     * @param message the message
     * @param data    the data that contains ID and delivery required flag
     */
    public void populateMessage(DownstreamMessage message, Pack data) {
        String messageId = data.getString(Constants.getVal(Constants.F_MESSAGE_ID), null);
        message.setMessageId(messageId);

        if (data.containsKey(Constants.getVal(Constants.F_DELIVERY_REQUIRED))) {
            boolean delivery = data.getBool(Constants.getVal(Constants.F_DELIVERY_REQUIRED), false);
            message.setDeliveryRequired(delivery);
        }

        //check if message is welcomeMsg notification
        if(message instanceof NotificationTypesDownstreamMessage) {
            String otk = data.getString(Constants.getVal(Constants.ONE_TIME_KEY), "");
            NotificationTypesDownstreamMessage msg = (NotificationTypesDownstreamMessage) message;
            if (!otk.isEmpty() && otk.equals(Constants.getVal(Constants.WELCOME_MSG))) {
                msg.setIsWelcomeMsg(true);
            }else {
                msg.setIsWelcomeMsg(false);
            }

            int updateAppVersion = data.getInt(Constants.getVal(Constants.UPDATE_APP_VERSION_CODE), -1);
            if(updateAppVersion > 0 ){
                msg.setAppUpdateVersion(updateAppVersion);
            }
        }
    }
}
