package com.pushpole.sdk.controller.factory;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.controller.DownstreamApiFactory;
import com.pushpole.sdk.controller.controllers.NotificationController;

/***
 * factory class for generating {@link NotificationController} instance
 */
public class NotificationApiFactory implements DownstreamApiFactory {

    /**
     * generate{@link NotificationController} instance
     *
     * @param context
     * @return
     */
    @Override
    public DownstreamApiController buildDownstreamHandler(Context context) {
        return new NotificationController(context);
    }
}
