package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.ExceptionCatcher;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.internal.log.Sentry;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.downstream.UserSentryConfigMessage;


/**
 * Created on 16-09-15, 11:21 AM.
 *
 * @author Akram Shokri
 */
public class UserSentryConfigController implements DownstreamApiController {

    private Context mContext;

    public UserSentryConfigController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        UserSentryConfigMessage sentryConfigMessage = (UserSentryConfigMessage) message;
        Logger.debug("Handling PushPole message using sentry. DSN:" + sentryConfigMessage.getUserDsnUrl());

        KeyStore.getInstance(mContext).putString(PlainConstants.USER_DSN_URL_KEYSTORE, sentryConfigMessage.getUserDsnUrl());
        KeyStore.getInstance(mContext).putInt(Constants.getVal(Constants.USER_CRASH_REPORT_PERCENT_KEYSTORE), sentryConfigMessage.getUserPercent());
        Logger.debug("Changing sentry error percent to " + sentryConfigMessage.getUserPercent());
        Sentry.init(mContext, sentryConfigMessage.getUserDsnUrl());
        ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);//set our exceptionCatcher as default catcher (just to be sure!)
     }
}
