package com.pushpole.sdk.action.actions;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Cafe Bazaar Rate Action; Opens Cafe Bazaar rating activity for the application.
 */
public class CafeBazaarRateAction extends IntentAction {
    private final static String CAFE_BAZAAR_PACKAGE = "com.farsitel.bazaar";

    /**
     * execute action
     * show cafe Bazaar rating activity
     *
     * @param context
     */
    @Override
    public void execute(Context context) {
        Logger.info("Starting " + context.getPackageName() + " page in market...");
        mData = "bazaar://details?id=" + context.getPackageName();
        super.execute(context);
    }

    /**
     * return type
     *
     * @return {@code ActionType.CAFE_BAZAAR_RATE}
     */
    @Override
    public ActionType getActionType() {
        return ActionType.CAFE_BAZAAR_RATE;
    }

    /***
     * factory class to generate {@link CafeBazaarRateAction} instance
     */
    public static class Factory extends ActionFactory {
        /**
         * generate {@link CafeBazaarRateAction} instance
         *
         * @param data the data to create the {@code Action} with given as a {@link Pack}
         * @return
         */
        @Override
        public Action buildAction(Pack data) {
            CafeBazaarRateAction action = new CafeBazaarRateAction();
            action.mAction = Intent.ACTION_EDIT;
            action.mPackage = CAFE_BAZAAR_PACKAGE;
            return action;
        }
    }
}
