package com.pushpole.sdk.action;

import com.pushpole.sdk.util.Pack;

/**
 * A Factory class to create an instance of a specific {@link Action}.
 * <p>
 * When creating a new {@code Action}, extend this class to create instances of your {@code Action}
 *
 * @author Hadi Zolfaghari
 */
public abstract class ActionFactory {
    /**
     * Builds an {@link Action} instance with the specific data given.
     * <p>
     * Override this method to create instances of your {@code Action} using the given data.
     *
     * @param data the data to create the {@code Action} with given as a {@link Pack}
     * @return the new instance of the {@code Action}
     */
    public abstract Action buildAction(Pack data);
}
