package com.pushpole.sdk.util;

import android.content.Context;
import android.os.PowerManager;

/***
 * A helper class to control wakeLock, making the screen off and on
 */
public class ScreenWaker {
    private final static String WAKE_LOCK_TAG = "com.pushpole.sdk.WAKE_LOCK";

    /***
     * a helper method to get screen wakeLock and release it,
     * the screen will turn off after screen sleep timeout
     *
     * @param context
     */
    public static void wakeScreen(Context context) {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        PowerManager.WakeLock wakeLock = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK
                | PowerManager.ACQUIRE_CAUSES_WAKEUP
                | PowerManager.ON_AFTER_RELEASE, WAKE_LOCK_TAG);
        wakeLock.acquire();
        wakeLock.release();
    }

}
