package com.pushpole.sdk.task.tasks;

import android.content.Context;
import com.pushpole.sdk.internal.log.Sentry;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.util.Pack;

/***
 * A class that represent task for sending sentry report
 */
public class SentryReportTask implements PushPoleTask {

    /***
     * The runTask contains operations for sending sentry report
     *
     * @param context  the app context
     * @param taskPack the task pack
     * @return * @return {@code RESULT_SUCCESS} or {@code RESULT_RESCHEDULE}
     */
    @Override
    public Result runTask(Context context, Pack taskPack) {
        //below is call to PushPole's Sentry.java class which is replaced by call to sentry-android.jar method
        /*boolean noRequestsLeft = Sentry.getInstance(context).sendSavedRequests();
        if (!noRequestsLeft) {
            return PushPoleTask.RESULT_RESCHEDULE;
        }
        return PushPoleTask.RESULT_SUCCESS;*/

        try {
            Sentry.sendAllCachedCapturedEvents();
            return Result.SUCCESS;
        } catch (Throwable e) {
            return Result.RESCHEDULE;
        }

    }
}
