package com.pushpole.sdk;

import com.pushpole.sdk.util.Pack;

public class NotificationButtonData {
    private String text;
    private int id;

    public NotificationButtonData(String text, int id) {
        this.text = text;
        this.id = id;
    }

    public String getText() {
        return text;
    }

    public int getId() {
        return id;
    }

    public Pack toPack() {
        Pack pack = new Pack();
        pack.putString(Constants.getVal(Constants.F_BIG_CONTENT), getText());
        pack.putInt(Constants.getVal(Constants.F_BUTTON_ID), getId());
        return pack;
    }

    public static NotificationButtonData fromPack(Pack pack) {
        return new NotificationButtonData(
                pack.getString(Constants.getVal(Constants.F_BIG_CONTENT), null),
                pack.getInt(Constants.getVal(Constants.F_BUTTON_ID), -1)
        );
    }

    @Override
    public String toString() {
        return toPack().toJson();
    }
}
