package com.pushpole.sdk.util;

import android.content.Context;

public class MaterialIconHelper {

    /**
     * Get an icon resource id by its material design icon name
     *
     * @param context A valid context for the application
     * @param name    The name of the material design icon. Valid name formats are: "shopping cart",
     *                "shopping-cart" and "shopping_cart"
     * @return The resource id of the icon
     */
    public static int getIconResourceByMaterialName(Context context, String name) {
        if(name == null)
            return 0; //to prevent null pointer exception
        String mName = "ic_" + name.replaceAll("[- ]", "_"); //TODO @ak, check name to be not null
        return context.getResources().getIdentifier(mName, "drawable", context.getPackageName());
    }
}
