package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.activities.WebviewActivity;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.downstream.WebviewWithoutShowingNotif;

/**
 * Created on 16-07-12, 7:04 PM.
 *
 * @author Akram Shokri
 */
public class WebviewDontShowNotifController implements DownstreamApiController {
    private Context mContext;

    public WebviewDontShowNotifController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage downstreamMessage) {
        if (!DownstreamMessage.Type.WEBVIEW_NOT_SHOW_NOTIFICATION.equals(downstreamMessage.getMessageType())) {
            return;
        }

        boolean isNotificationOff = KeyStore.getInstance(mContext).getBoolean(Constants.getVal(Constants.NOTIFICATION_OFF), false);

        if (isNotificationOff) {
            return;
        }

        WebviewWithoutShowingNotif message = (WebviewWithoutShowingNotif) downstreamMessage;

        //handle welcome message notification
        if (message.isWelcomeMsg() && !message.showWelcomeNotificationMsg(mContext))
            return;

        //handle update app notification message
        if(message.isUpdateAppNotification() && ! message.showUpdateAppNotification(mContext))
            return;

        Intent intent = new Intent(mContext, WebviewActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

        intent.putExtra(Constants.getVal(Constants.WEBVIEW_URL), message.getUrl());
        intent.putExtra(Constants.getVal(Constants.WEBVIEW_ORIG_MSG_ID), message.getOriginalMsgId());
        intent.setAction(Constants.getVal(Constants.ACTION_SHOW_WEBVIEW));
        mContext.startActivity(intent);

    }
}
