package com.pushpole.sdk.collection.tasks;

import android.content.Context;
import android.support.annotation.NonNull;

import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.controllers.SyncApplicationsController;
import com.pushpole.sdk.device.ApplicationDetails;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created by vahid on 7/16/16.
 */
@SingletonTask
@DefaultOptions(period = 14 * 24 * 60 * 60 * 1000) //default schedule: 14 days
public class AppListTask extends CollectionTask {
    @NonNull
    @Override
    public Result runTask(Context context, Pack taskData) {
        if (taskData == null || !taskData.getBool("force")) {
            long collectionPeriod = KeyStore.getInstance(context).getLong("collection_period_t14", 14 * 24 * 60 * 60 * 1000L);
            Long lastCollectionTime = KeyStore.getInstance(context).getLong("last_collection_t14", 0);

            if (collectionPeriod == -1) {
                Logger.warning("Skipping app list collection, the collection has been cancelled and should not run");
                return Result.SUCCESS;
            } else {
                Long now = System.currentTimeMillis();
                if (lastCollectionTime > 0 && now > lastCollectionTime && (now - lastCollectionTime) < collectionPeriod) {
                    Logger.warning("Skipping app list collection since it has already been run in this interval", new LogData(
                            "Last Run", String.valueOf(lastCollectionTime),
                            "Now", String.valueOf(now),
                            "Period", String.valueOf(collectionPeriod)
                    ));

                    return Result.SUCCESS;
                }
                KeyStore.getInstance(context).putLong("last_collection_t14", now);
            }
        }

        List <ApplicationDetails> allApps = new SyncApplicationsController(context).getAllInstalledApps();
        //TODO: save applist as a list of 3100 byte in db or send it
        Collections.sort(allApps); //sort appList by first-install-time
        for (ApplicationDetails app : allApps) {
            this.processResult(context, app.toPack(), Constants.getVal(Constants.APP_LIST_T));
        }
        return Result.SUCCESS;
    }
}
