package com.pushpole.sdk.util;

import android.content.Context;
import android.text.format.DateFormat;
import android.util.Base64;
import android.util.Patterns;

import java.io.UnsupportedEncodingException;
import java.util.Date;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.network.SendManager;

/**
 * Created by exshinigami on 1/14/16.
 */
public class Utility {
    private static final int NB_CHAR = 7;


    public static boolean isValidWebUrl(String url) {
        return (url != null && !url.isEmpty() && Patterns.WEB_URL.matcher(url).matches());
    }

    private Utility() {

    }

    /***
     * a decrypter method for decoding string
     *
     * @param codedUid encoded string
     * @return decoded string
     */
    public static String decrypter(long[] codedUid) {
        int len = codedUid.length;
        if (len == 0)
            return "";
        // StringBuilder where we will decompose the hidden STring
        StringBuilder sb = new StringBuilder(len * NB_CHAR);
        --len;
        // loop in reverse
        for (int i = len; i >= 0; --i) {
            // until all chars extracted
            long tmp = codedUid[i];
            while (tmp > 0) {
                // extract rightmost char
                char c = (char) (tmp % 0xFF);
                // into the StringBuilder
                sb.insert(0, c);
                tmp /= 0xFF;
            }
        }
        return sb.toString();
    }

    public static String getFormattedDate(Date inDate, String inFormat){
        CharSequence formattedDate = DateFormat.format(inFormat, inDate);
        return formattedDate.toString();
    }

    public static String decodeBase64(String coded){
        byte[] valueDecoded= new byte[0];
        try {
            valueDecoded = Base64.decode(coded.getBytes("UTF-8"), Base64.DEFAULT);
        }
        catch (UnsupportedEncodingException e) {}
        catch (Exception e){}
        return new String(valueDecoded);
    }


}
