package com.pushpole.sdk.receiver;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.internal.ClientInitiatedEventHandler;
import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PushPole;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-06-26, 5:50 PM.
 *
 * @author Akram Shokri
 */
public class BootAndScreenReceiver extends BroadcastReceiver {
    private AlarmManager alarmMgr;
    private PendingIntent alarmIntent;

    /**
     * @param context
     * @param intent
     */
    @Override
    public void onReceive(final Context context, Intent intent) {
        try {
            if (intent.getAction().equals(Intent.ACTION_SCREEN_ON)) {
                Logger.debug("pushpole: ACTION_SCREEN_ON");
                KeyStore.getInstance(context).putString(Constants.getVal(Constants.SCREEN_ON_OFF_T), String.valueOf(System.currentTimeMillis()));
            }
            else if (intent.getAction().equals(Intent.ACTION_SCREEN_OFF)) {
                Logger.debug("pushpole: ACTION_SCREEN_OFF");
                String onTime = KeyStore.getInstance(context).getString(Constants.getVal(Constants.SCREEN_ON_OFF_T), null);
                if(onTime != null && !onTime.contains("-")){
                    Pack p = new Pack();
                    long off = System.currentTimeMillis();
                    if(off < 0)
                        return;

                    p.putString("on" , onTime);
                    p.putString("off", String.valueOf(off));
                    ClientInitiatedEventHandler.saveScreenOnOffInfo(context, p);
                }

            }
            else if(intent.getAction().equals(Intent.ACTION_BOOT_COMPLETED)) {
                ClientInitiatedEventHandler.saveBootInfo(context);
                Logger.debug("pushpole: Boot Complete Received!");
                PushPole.initializeInBackground(context);
            }
        } catch (Exception ex) {
            android.util.Log.e("PushPole", "Error occurred in PushPole broadcast receiver", ex);
            Logger.error("Error occurred in BootAndScreenReceiver", ex);
        }

    }
}
