package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-04-18, 9:43 AM.
 *
 * @author Akram Shokri
 */


public class ConnectivityInfoMessage extends DownstreamMessage {
    private int threshold;
    @Override
    public DownstreamMessage.Type getMessageType() {
        return Type.CONNECTIVITY_INFO;
    }

    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            ConnectivityInfoMessage message = new ConnectivityInfoMessage();
            message.threshold = data.getInt(Constants.getVal(Constants.CONNECTION_INFO_THRESHOLD), 0);

            return message;
        }
    }

    public int getThreshold() {
        return threshold;
    }
}