package com.pushpole.sdk.message.downstream;

import android.content.Context;
import android.content.pm.PackageManager;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-31, 4:59 PM.
 *
 * @author Akram Shokri
 */
public abstract class NotificationTypesDownstreamMessage extends DownstreamMessage {
    private boolean isWelcomeMsg;
    private int mAppUpdateVersion; //used for update notification message

    public static void setWelcomeMsgSeen(Context context) {
        Pack p = KeyStore.getInstance(context).getPack(Constants.getVal(Constants.ONE_TIME_KEY), null);
        if (p == null)
            p = new Pack();
        p.putBool(Constants.getVal(Constants.WELCOME_MSG), true);
        KeyStore.getInstance(context).putPack(Constants.getVal(Constants.ONE_TIME_KEY), p);
    }

    public static boolean containsOTKKey(Context context, String key) {
        Pack pack = KeyStore.getInstance(context).getPack(Constants.getVal(Constants.ONE_TIME_KEY), null);
        if (pack != null) {
            return pack.getBool(key, false); //if contains this key, means don't show notifications that contain this key anymore
        }
        return false;
    }

    public boolean isWelcomeMsg() {
        return isWelcomeMsg;
    }

    public void setIsWelcomeMsg(boolean isWelcomeMsg) {
        this.isWelcomeMsg = isWelcomeMsg;
    }

    public int getAppUpdateVersion() {
        return mAppUpdateVersion;
    }

    public void setAppUpdateVersion(int appNewVersion) {
        this.mAppUpdateVersion = appNewVersion;
    }

    public boolean showWelcomeNotificationMsg(Context context) {
        //handle welcome message notification
        boolean showWelcomeMsg = !containsOTKKey(context, Constants.getVal(Constants.WELCOME_MSG));
        if (showWelcomeMsg) {
            setWelcomeMsgSeen(context);
            return true;
        } else {
            return false;
        }
    }

    public boolean showUpdateAppNotification(Context context) {
        try {
            int currentAppVersion = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
            if (getAppUpdateVersion() > currentAppVersion)
                return true;
        } catch (PackageManager.NameNotFoundException e) {
        }

        return false;
    }

    public boolean isUpdateAppNotification(){
        return getAppUpdateVersion() > 0;
    }
}
