package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.downstream.UpdateConfigMessage;
import com.pushpole.sdk.util.Pack;


/**
 * To send a config message to the SDK:
 * - Use t61 as type.
 * - Following format in the message:
 *      Update: `{ "update" : { "key":"value" } }`
 *      Remove: `{ "remove" : ["key1", "key2" ] }`
 *
 * e.g:
 *  "t61" : {
 *      "update" : {
 *          "log_collection_enabled" : "false" // This'll disable logCollection
 *      }
 *  }
 *
 * @author Mahdi
 */
public class UpdateConfigApiController implements DownstreamApiController {

    private Context mContext;

    public UpdateConfigApiController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        UpdateConfigMessage configMessage = (UpdateConfigMessage) message;
        KeyStore store = KeyStore.getInstance(mContext);
        String removes = configMessage.getRemoveKeys();
        try {
            String[] list = removes.substring(1, removes.length() - 1).split(", ");
            for (String i : list) {
                store.delete(i);
            }
        } catch (Exception e) {
            Logger.warning("Failed to remove config:\n" + e.getMessage());
        }

        Pack updates = configMessage.getUpdates();
        if (updates != null) {
            try {
                for (String i : updates.keySet()) {
                    if (updates.get(i) instanceof String) {
                        store.putString(i, (String) updates.get(i));
                    }
                }
            } catch (Exception e) {
                Logger.error("Failed to update store:\n" + e.getMessage());
            }
        }
    }
}
