package com.pushpole.sdk.message.downstream;

import android.app.Notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

import static com.pushpole.sdk.Constants.F_ACTION;
import static com.pushpole.sdk.Constants.F_ACTION_TYPE;
import static com.pushpole.sdk.Constants.F_BIG_CONTENT;
import static com.pushpole.sdk.Constants.F_BIG_ICON_URL;
import static com.pushpole.sdk.Constants.F_BIG_TITLE;
import static com.pushpole.sdk.Constants.F_BUTTONS;
import static com.pushpole.sdk.Constants.F_BUTTON_ACTION;
import static com.pushpole.sdk.Constants.F_BUTTON_CONTENT;
import static com.pushpole.sdk.Constants.F_BUTTON_ICON;
import static com.pushpole.sdk.Constants.F_BUTTON_ID;
import static com.pushpole.sdk.Constants.F_BUTTON_ORDER;
import static com.pushpole.sdk.Constants.F_CONTENT;
import static com.pushpole.sdk.Constants.F_CUSTOM_CONTENT;
import static com.pushpole.sdk.Constants.F_DBIG_CONTENT;
import static com.pushpole.sdk.Constants.F_DBIG_ICON_URL;
import static com.pushpole.sdk.Constants.F_DBIG_TITLE;
import static com.pushpole.sdk.Constants.F_DBUTTONS;
import static com.pushpole.sdk.Constants.F_DCONTENT;
import static com.pushpole.sdk.Constants.F_DIALOG_INPUT_1;
import static com.pushpole.sdk.Constants.F_DIALOG_INPUT_2;
import static com.pushpole.sdk.Constants.F_DICON_URL;
import static com.pushpole.sdk.Constants.F_DIMAGE_URL;
import static com.pushpole.sdk.Constants.F_DSUMMARY;
import static com.pushpole.sdk.Constants.F_DTITLE;
import static com.pushpole.sdk.Constants.F_FORCE_PUBLISH;
import static com.pushpole.sdk.Constants.F_ICON_URL;
import static com.pushpole.sdk.Constants.F_IMAGE_URL;
import static com.pushpole.sdk.Constants.F_IMG_NOTIF_URL;
import static com.pushpole.sdk.Constants.F_LED_COLOR;
import static com.pushpole.sdk.Constants.F_LED_OFFTIME;
import static com.pushpole.sdk.Constants.F_LED_ONTIME;
import static com.pushpole.sdk.Constants.F_NOTIF_CHANNEL_ID;
import static com.pushpole.sdk.Constants.F_NOTIF_ICON;
import static com.pushpole.sdk.Constants.F_ORIGINAL_MESSAGE_ID;
import static com.pushpole.sdk.Constants.F_PERMANENT_PUSH;
import static com.pushpole.sdk.Constants.F_PRIORITY;
import static com.pushpole.sdk.Constants.F_SHOW_NOTIFICATION;
import static com.pushpole.sdk.Constants.F_SOUND_URL;
import static com.pushpole.sdk.Constants.F_MESSAGE_ID;
import static com.pushpole.sdk.Constants.F_SUMMARY;
import static com.pushpole.sdk.Constants.F_TICKER;
import static com.pushpole.sdk.Constants.F_TITLE;
import static com.pushpole.sdk.Constants.F_WAKE_SCREEN;
import static com.pushpole.sdk.util.Utility.isValidWebUrl;

/***
 * A class that represent downstream message for pushpole_custom_notification
 */
public class NotificationDownstreamMessage extends NotificationTypesDownstreamMessage {
//    public final static int NO_SOUND = -1;
//    public final static int DEFAULT_SOUND = 0;

    private String mTitle;
    private String mContent;
    private String mBigTitle;
    private String mBigContent;
    private String mSummary;
    private Action mAction;
    private int mPriority;
    private String mImageUrl;
    private String mIconUrl;
    private String mBigIconUrl;
    private boolean mUsePushPoleIcon;
    private int mLedColor;
    private int mLedOnTime;
    private int mLedOffTime;
    private List<Button> mButtons;
    private boolean mWakeScreen;
    private String mTicker;
    //    private int mSoundId;
    private String mSoundUrl;
    private Pack mCustomContent;
    private boolean mShowNotification;
    private String mJustImageUrl; //img-url for small notification that only shows an image background
    private String mNotifIcon;
    private boolean mPermanentPush;
    private boolean mForcePublish;
    private boolean mRetryImgFetch;
    private String mNotifChannelID;

    @Override
    public DownstreamMessage.Type getMessageType() {
        return Type.NOTIFICATION;
    }

    public Action getAction() {
        return mAction;
    }

    public void setAction(Action action) {
        mAction = action;
    }

    public String getTitle() {
        return mTitle;
    }

    public void setTitle(String title) {
        mTitle = title;
    }

    public String getContent() {
        return mContent;
    }

    public void setContent(String content) {
        mContent = content;
    }

    public String getBigTitle() {
        return mBigTitle;
    }

    public void setBigTitle(String bigTitle) {
        mBigTitle = bigTitle;
    }

    public String getBigContent() {
        return mBigContent;
    }

    public void setBigContent(String bigContent) {
        mBigContent = bigContent;
    }

    public String getSummary() {
        return mSummary;
    }

    public void setSummary(String summary) {
        mSummary = summary;
    }

    public int getPriority() {
        return mPriority;
    }

    public void setPriority(int priority) {
        mPriority = priority;
    }

    public List<Button> getButtons() {
        return mButtons;
    }

    public void setButtons(List<Button> buttons) {
        mButtons = buttons;
    }

    public String getImageUrl() {
        return mImageUrl;
    }

    public void setImageUrl(String imageUrl) {
        mImageUrl = imageUrl;
    }

    public String getIconUrl() {
        return mIconUrl;
    }

    public void setIconUrl(String iconUrl) {
        mIconUrl = iconUrl;
    }

    public String getBigIconUrl() {
        return mBigIconUrl;
    }

    public void setBigIconUrl(String bigIconUrl) {
        mBigIconUrl = bigIconUrl;
    }

    public int getLedColor() {
        return mLedColor;
    }

    public void setLedColor(int ledColor) {
        mLedColor = ledColor;
    }

    public int getLedOnTime() {
        return mLedOnTime;
    }


    public void setLedOnTime(int ledOnTime) {
        mLedOnTime = ledOnTime;
    }

    public int getLedOffTime() {
        return mLedOffTime;
    }

    public void setLedOffTime(int ledOffTime) {
        mLedOffTime = ledOffTime;
    }

    public boolean getUsePushPoleIcon() {
        return mUsePushPoleIcon;
    }

    public void setUsePushPoleIcon(boolean usePushPoleIcon) {
        mUsePushPoleIcon = usePushPoleIcon;
    }

    public boolean getWakeScreen() {
        return mWakeScreen;
    }

    public void setWakeScreen(boolean wakeScreen) {
        mWakeScreen = wakeScreen;
    }

    public String getTicker() {
        return mTicker;
    }

    public void setTicker(String ticker) {
        mTicker = ticker;
    }

//    public int getSoundId() {
//        return mSoundId;
//    }

//    public void setSoundId(int soundId) {
//        mSoundId = soundId;
//    }


    public String getSoundUrl() {
        return mSoundUrl;
    }

    public void setSoundUrl(String mSoundUrl) {
        this.mSoundUrl = mSoundUrl;
    }

    public boolean hasValidSoundToPlay() {
        return getSoundUrl() != null && isValidWebUrl(getSoundUrl());
    }

    public Pack getCustomContent() {
        return mCustomContent;
    }

    public void setCustomContent(Pack customData) {
        mCustomContent = customData;
    }

    public boolean getShowNotification() {
        return mShowNotification;
    }

    public void setShowNotification(boolean showNotification) {
        mShowNotification = showNotification;
    }

    public String getJustImageUrl() {
        return mJustImageUrl;
    }

    public void setJustImageUrl(String mJustImageUrl) {
        this.mJustImageUrl = mJustImageUrl;
    }

    public String getNotifIcon() {
        return mNotifIcon;
    }

    public void setNotifIcon(String mNotifIcon) {
        this.mNotifIcon = mNotifIcon;
    }

    public boolean isPermanentPush() {
        return mPermanentPush;
    }

    public void setPermanentPush(boolean mPermanentPush) {
        this.mPermanentPush = mPermanentPush;
    }

    public boolean isForcePublish() {
        return mForcePublish;
    }

    public void setForcePublish(boolean mForcePublish) {
        this.mForcePublish = mForcePublish;
    }

    public boolean isRetryImgFetch() {
        return mRetryImgFetch;
    }

    public void setRetryImgFetch(boolean retryImgFetch) {
        this.mRetryImgFetch = retryImgFetch;
    }

    public String getNotifChannelID() {
        return mNotifChannelID;
    }

    public void setNotifChannelID(String notifChannelID) {
        this.mNotifChannelID = notifChannelID;
    }

    @Override
    public Pack toPack() {
        Pack pack = super.toPack();

        pack.putString(Constants.getVal(F_TITLE), mTitle);
        pack.putString(Constants.getVal(F_CONTENT), mContent);
        pack.putString(Constants.getVal(F_BIG_TITLE), mBigTitle);
        pack.putString(Constants.getVal(F_BIG_CONTENT), mBigContent);
        pack.putString(Constants.getVal(F_SUMMARY), mSummary);

        if (mAction != null) {
            pack.putPack(Constants.getVal(F_ACTION), mAction.toPack());
        }
        pack.putString(Constants.getVal(F_PRIORITY), String.valueOf(mPriority));
        pack.putString(Constants.getVal(F_ICON_URL), mIconUrl);
        pack.putString(Constants.getVal(F_IMAGE_URL), mImageUrl);
        pack.putString(Constants.getVal(F_BIG_ICON_URL), mBigIconUrl);
        pack.putString(Constants.getVal(F_LED_COLOR), String.valueOf(mLedColor));
        pack.putString(Constants.getVal(F_LED_ONTIME), String.valueOf(mLedOnTime));
        pack.putString(Constants.getVal(F_LED_OFFTIME), String.valueOf(mLedOffTime));
        pack.putString(PlainConstants.F_USE_PUSHPOLE_MINIICON, String.valueOf(mUsePushPoleIcon));
        pack.putString(Constants.getVal(F_WAKE_SCREEN), String.valueOf(mWakeScreen));
        pack.putString(Constants.getVal(F_TICKER), mTicker);
//        pack.putString(F_SOUND, String.valueOf(mSoundId));

        pack.putPack(Constants.getVal(F_CUSTOM_CONTENT), mCustomContent);
        pack.putString(Constants.getVal(F_SHOW_NOTIFICATION), String.valueOf(mShowNotification));
        pack.putString(Constants.getVal(F_IMG_NOTIF_URL), mJustImageUrl);
        pack.putString(Constants.getVal(F_NOTIF_CHANNEL_ID), mNotifChannelID);

        if (mButtons != null) {
            ListPack listPack = new ListPack();
            for (Button button : mButtons) {
                listPack.addPack(button.toPack());
            }
            pack.putListPack(Constants.getVal(F_BUTTONS), listPack);
        }

        return pack;
    }

    public static class Button {
        private Action mAction;
        private String mText;
        private String mIcon;
        private int mOrder;
        private int mId;

        public Action getAction() {
            return mAction;
        }

        public void setAction(Action action) {
            mAction = action;
        }

        public String getText() {
            return mText;
        }

        public void setText(String text) {
            mText = text;
        }

        public int getOrder() {
            return mOrder;
        }

        public void setOrder(int order) {
            mOrder = order;
        }

        public int getId() {
            return mId;
        }

        public void setId(int id) {
            mId = id;
        }

        public String getIcon() {
            return mIcon;
        }

        public void setIcon(String icon) {
            mIcon = icon;
        }

        public Pack toPack() {
            Pack pack = new Pack();
            pack.putInt(Constants.getVal(F_BUTTON_ID), mId);
            pack.putInt(Constants.getVal(F_BUTTON_ORDER), mOrder);
            pack.putString(Constants.getVal(F_BIG_CONTENT), mText);
            pack.putString(Constants.getVal(F_BUTTON_ICON), mIcon);
            if (mAction != null) {
                pack.putPack(Constants.getVal(F_BUTTON_ACTION), mAction.toPack());
            }
            return pack;
        }
    }

    /***
     * Factory class to generate {@link NotificationDownstreamMessage} instance
     */
    public static class Factory extends DownstreamMessageFactory {
        public final static int DEFAULT_PRIORITY = 2;
        public final static ActionType DEFAULT_ACTION_TYPE = ActionType.APP;
        public final static int DEFAULT_LED_COLOR = 0;
        public final static int DEFAULT_LED_ON_TIME = 500;
        public final static int DEFAULT_LED_OFF_TIME = 1000;

        /**
         * Builds action related to message. If the ActionType being built has the requireMessageData set then message data
         * will be copied to the actionData before being passed to the factory.
         *
         * @param actionData  The data to be passed to the action factory
         * @param messageData Data for the NotificationDownstreamMessage containing the action
         * @return The new Action
         */
        private static Action createAction(Pack actionData, Pack messageData) {
            if (actionData == null) {
                return null;
            }

            String actionTypeStr = actionData.getString(Constants.getVal(F_ACTION_TYPE), null);
            ActionType actionType = ActionType.fromCode(actionTypeStr);
            if (actionType == null) {
                actionType = DEFAULT_ACTION_TYPE;
            }

            // for intent and dialog
            if (actionType.requiresMessageData()) {
                if (messageData.getString(Constants.getVal(F_DTITLE)) != null
                        && messageData.getString(Constants.getVal(F_DCONTENT)) != null) {
                    actionData.putString(Constants.getVal(F_DTITLE),
                            messageData.getString(Constants.getVal(F_DTITLE)));
                    actionData.putString(Constants.getVal(F_DBIG_TITLE),
                            messageData.getString(Constants.getVal(F_DBIG_TITLE)));
                    actionData.putString(Constants.getVal(F_DCONTENT),
                            messageData.getString(Constants.getVal(F_DCONTENT)));
                    actionData.putString(Constants.getVal(F_DBIG_CONTENT),
                            messageData.getString(Constants.getVal(F_DBIG_CONTENT)));
                    actionData.putString(Constants.getVal(F_DSUMMARY),
                            messageData.getString(Constants.getVal(F_DSUMMARY)));
                    actionData.putString(Constants.getVal(F_DIMAGE_URL),
                            messageData.getString(Constants.getVal(F_DIMAGE_URL)));
                    actionData.putString(Constants.getVal(F_DICON_URL),
                            messageData.getString(Constants.getVal(F_DICON_URL)));
                    actionData.putString(Constants.getVal(F_DBIG_ICON_URL),
                            messageData.getString(Constants.getVal(F_DBIG_ICON_URL)));
                } else {
                    actionData.putString(Constants.getVal(F_TITLE),
                            messageData.getString(Constants.getVal(F_TITLE)));
                    actionData.putString(Constants.getVal(F_BIG_TITLE),
                            messageData.getString(Constants.getVal(F_BIG_TITLE)));
                    actionData.putString(Constants.getVal(F_CONTENT),
                            messageData.getString(Constants.getVal(F_CONTENT)));
                    actionData.putString(Constants.getVal(F_BIG_CONTENT),
                            messageData.getString(Constants.getVal(F_BIG_CONTENT)));
                    actionData.putString(Constants.getVal(F_SUMMARY),
                            messageData.getString(Constants.getVal(F_SUMMARY)));
                    actionData.putString(Constants.getVal(F_IMAGE_URL),
                            messageData.getString(Constants.getVal(F_IMAGE_URL)));
                    actionData.putString(Constants.getVal(F_ICON_URL),
                            messageData.getString(Constants.getVal(F_ICON_URL)));
                    actionData.putString(Constants.getVal(F_BIG_ICON_URL),
                            messageData.getString(Constants.getVal(F_BIG_ICON_URL)));
                }

                actionData.putString(Constants.getVal(F_DIALOG_INPUT_1), messageData.getString(Constants.getVal(F_DIALOG_INPUT_1), ""));
                actionData.putString(Constants.getVal(F_DIALOG_INPUT_2), messageData.getString(Constants.getVal(F_DIALOG_INPUT_2), ""));
                actionData.putString(Constants.getVal(F_ORIGINAL_MESSAGE_ID), messageData.getString(Constants.getVal(F_MESSAGE_ID), ""));
                if (actionType == ActionType.DIALOG) {
                    if (messageData.getListPack(Constants.getVal(F_DBUTTONS)) != null)
                        actionData.putListPack(Constants.getVal(F_DBUTTONS),
                                removeDialogBtnFromBtns(messageData.getListPack(Constants.getVal(F_DBUTTONS))));
                    else
                        actionData.putListPack(Constants.getVal(F_BUTTONS),
                                removeDialogBtnFromBtns(messageData.getListPack(Constants.getVal(F_BUTTONS))));
                } else {
                    actionData.putListPack(Constants.getVal(F_BUTTONS),
                            messageData.getListPack(Constants.getVal(F_BUTTONS)));
                }
            }

            return actionType.getFactory().buildAction(actionData);
        }

        private static ListPack removeDialogBtnFromBtns(ListPack buttonsListPack) {
            if (buttonsListPack == null)
                return null;
            ListPack res = new ListPack();
            for (int i = 0; i < buttonsListPack.size(); i++) {
                Pack buttonsInfoPack = buttonsListPack.getPack(i);

                Pack btnAction = buttonsInfoPack.getPack(Constants.getVal(F_BUTTON_ACTION));
                String actionTypeStr = btnAction.getString(Constants.getVal(F_ACTION_TYPE), null);
                ActionType actionType = ActionType.fromCode(actionTypeStr);
                if (actionType != ActionType.DIALOG) {
                    res.add(buttonsInfoPack);
                }
            }
            return res;
        }

        /***
         * generate {@link NotificationDownstreamMessage} instance and populate it
         *
         * @param data the data for generating message
         * @return {@link DownstreamMessage} instance
         */
        @Override
        public DownstreamMessage buildMessage(Pack data) {
            NotificationDownstreamMessage message = new NotificationDownstreamMessage();
            populateMessage(message, data);

            message.setTitle(data.getString(Constants.getVal(F_TITLE), null));
            message.setContent(data.getString(Constants.getVal(F_CONTENT), null));
            message.setBigTitle(data.getString(Constants.getVal(F_BIG_TITLE), null));
            message.setBigContent(data.getString(Constants.getVal(F_BIG_CONTENT), null));
            message.setSummary(data.getString(Constants.getVal(F_SUMMARY), null));

            if (message.getBigContent() == null || message.getBigContent().isEmpty()) { //by default, setting content value to BigContent field in case bigContent is null
                message.setBigContent(message.getContent());
            }
            try {
                message.setPriority(Integer.parseInt(data.getString(Constants.getVal(F_PRIORITY))));
            } catch (NumberFormatException e) {
                message.setPriority(DEFAULT_PRIORITY);
            }

            message.setImageUrl(data.getString(Constants.getVal(F_IMAGE_URL), null));

            message.setIconUrl(data.getString(Constants.getVal(F_ICON_URL), null));

            message.setBigIconUrl(data.getString(Constants.getVal(F_BIG_ICON_URL), null));
            message.setUsePushPoleIcon(
                    Boolean.parseBoolean(data.getString(PlainConstants.F_USE_PUSHPOLE_MINIICON, "false"))
            );

            message.setAction(createAction(data.getPack(Constants.getVal(F_ACTION), null), data));//tODO:???

            try {
                message.setLedColor(Integer.parseInt(data.getString(Constants.getVal(F_LED_COLOR))));
            } catch (NumberFormatException e) {
                message.setLedColor(DEFAULT_LED_COLOR);
            }

            try {
                message.setLedOffTime(Integer.parseInt(data.getString(Constants.getVal(F_LED_OFFTIME))));
            } catch (NumberFormatException e) {
                message.setLedOffTime(DEFAULT_LED_OFF_TIME);//TODO: ???!
            }

            try {
                message.setLedOnTime(Integer.parseInt(data.getString(Constants.getVal(F_LED_ONTIME))));
            } catch (NumberFormatException e) {
                message.setLedOnTime(DEFAULT_LED_ON_TIME);//TODO: ???!
            }

            message.setWakeScreen(Boolean.parseBoolean(data.getString(Constants.getVal(F_WAKE_SCREEN), "false")));
            message.setTicker(data.getString(Constants.getVal(F_TICKER), null));

//            try {
//                message.setSoundId(Integer.parseInt(data.getString(F_SOUND)));
//            } catch (NumberFormatException e) {
//                message.setSoundId(DEFAULT_SOUND);
//            }

            message.setCustomContent(data.getPack(Constants.getVal(F_CUSTOM_CONTENT), null));
            message.setShowNotification(data.getBool(Constants.getVal(F_SHOW_NOTIFICATION), true));
            message.setNotifIcon(data.getString(Constants.getVal(F_NOTIF_ICON), null)); //if a custom icon from drawable is wanted as notifIcon
            message.setPermanentPush(data.getBool(Constants.getVal(F_PERMANENT_PUSH), false));
            message.setJustImageUrl(data.getString(Constants.getVal(F_IMG_NOTIF_URL), null));
            message.setForcePublish(data.getBool(Constants.getVal(F_FORCE_PUBLISH), false));
            message.setNotifChannelID(data.getString(Constants.getVal(F_NOTIF_CHANNEL_ID), null));

            ListPack buttons = data.getListPack(Constants.getVal(F_BUTTONS), null);//TODO: PAS-83
            if (buttons != null) {
                message.setButtons(new NotificationButtonFactory().buildButtonsFromListPack(data, buttons));

                // Sort buttons according to given order in message
                Collections.sort(message.getButtons(), new Comparator<Object>() {
                    @Override
                    public int compare(Object o1, Object o2) {
                        Button b1 = (Button) o1;
                        Button b2 = (Button) o2;

                        if (b1.getOrder() > b2.getOrder()) {
                            return -1;
                        } else if (b1.getOrder() < b2.getOrder()) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }

            message.setSoundUrl(data.getString(Constants.getVal(F_SOUND_URL), ""));
            return message;
        }

        /***
         * Factory class to generate pushpole_custom_notification's button
         */
        public static class NotificationButtonFactory {
            /***
             * Generate buttons and populated them
             *
             * @param messageData the message data for populating buttons
             * @param buttonsInfo {@link ListPack} of button
             * @return List of populated {@link com.pushpole.sdk.message.downstream.NotificationDownstreamMessage.Button} button
             */
            public List<NotificationDownstreamMessage.Button> buildButtonsFromListPack(Pack messageData,
                                                                                       ListPack buttonsInfo) {
                List<NotificationDownstreamMessage.Button> buttons = new ArrayList<>();
                for (int i = 0; i < buttonsInfo.size(); i++) {
                    Pack buttonsInfoPack = buttonsInfo.getPack(i);
                    NotificationDownstreamMessage.Button button = new Button();
                    button.setText(buttonsInfoPack.getString(Constants.getVal(F_BUTTON_CONTENT)));
                    button.setOrder(buttonsInfoPack.getInt(Constants.getVal(F_BUTTON_ORDER), 0));
                    button.setId(buttonsInfoPack.getInt(Constants.getVal(F_BUTTON_ID)));
                    button.setIcon(buttonsInfoPack.getString(Constants.getVal(F_BUTTON_ICON)));

                    button.setAction(createAction(buttonsInfoPack.getPack(Constants.getVal(F_BUTTON_ACTION)), messageData));
                    if ((button.getIcon() != null && !button.getIcon().isEmpty())
                            || (button.getText() != null && !button.getText().isEmpty()))
                        buttons.add(button);
                }

                return buttons;
            }
        }
    }


}
