package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.activities.PopupDialogActivity;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.message.downstream.DialogWhithoutShowingNotif;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.util.PackBundler;

/**
 * Created on 16-07-12, 6:04 PM.
 *
 * @author Akram Shokri
 */
public class DialogWhithoutShowingNotifController implements DownstreamApiController {
    private Context mContext;

    public DialogWhithoutShowingNotifController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage downstreamMessage) {
        if (!DownstreamMessage.Type.DIALOG_NOT_SHOW_NOTIFICATION.equals(downstreamMessage.getMessageType())) {
            return;
        }

        boolean isNotificationOff = KeyStore.getInstance(mContext).getBoolean(Constants.getVal(Constants.NOTIFICATION_OFF), false);

        if (isNotificationOff) {
            return;
        }

        DialogWhithoutShowingNotif message = (DialogWhithoutShowingNotif) downstreamMessage;

        //handle welcome message notification
        if (message.isWelcomeMsg() && !message.showWelcomeNotificationMsg(mContext))
            return;

        //handle update app notification message
        if(message.isUpdateAppNotification() && ! message.showUpdateAppNotification(mContext))
            return;

        if (!PopupDialogActivity.isDialogShowing()) {
            PopupDialogActivity.setDialogShowing(true);
            Intent intent = new Intent(mContext, PopupDialogActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

            intent.putExtras(PackBundler.packToBundle(message.getData()));
            intent.setAction(PlainConstants.ACTION_OPEN_DIALOG);
            mContext.startActivity(intent);
        }

    }
}
