package com.pushpole.sdk.activities;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.view.Gravity;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.R;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.message.downstream.NotificationDownstreamMessage;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PackBundler;

import java.util.List;

/**
 * The activity that contains a dialog to show
 */
public class PopupDialogActivity extends Activity {
    private static boolean dialogShowing = false;
    private Pack mData;
    private AlertDialog alertDialog = null;
    private boolean isInputDialog;
    private EditText editText1, editText2;
    private String input1Lable, input2Lable;

    public static boolean isDialogShowing() {
        return dialogShowing;
    }

    public static void setDialogShowing(boolean dialogShowing) {
        PopupDialogActivity.dialogShowing = dialogShowing;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mData = PackBundler.bundleToPack(getIntent().getExtras());

        if (PlainConstants.ACTION_OPEN_DIALOG.equals(getIntent().getAction())) {
            createAndShowDialog();
        }
    }


    /**
     * Create a {@link AlertDialog} asynchronously
     * the dialog contains {@link com.pushpole.sdk.message.downstream.DownstreamMessage} content and close button
     */
    private void createAndShowDialog() {
        final Context context = this;
        isInputDialog = false;
        TaskManager.getInstance(context).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(final Context ctx) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(context);

                String title = mData.getString(Constants.getVal(Constants.F_DTITLE), null);
                String content = mData.getString(Constants.getVal(Constants.F_DCONTENT), null);
                String bigTitle = mData.getString(Constants.getVal(Constants.F_DBIG_TITLE));
                String bigContent = mData.getString(Constants.getVal(Constants.F_DBIG_CONTENT));
                String iconUrl = mData.getString(Constants.getVal(Constants.F_DICON_URL));
                String bigIconUrl = mData.getString(Constants.getVal(Constants.F_DBIG_ICON_URL));
                ListPack buttons = mData.getListPack(Constants.getVal(Constants.F_DBUTTONS));

                if(title == null && content == null){ //This check is for supporting backward compatibility
                    title = mData.getString(Constants.getVal(Constants.F_TITLE), null);
                    content = mData.getString(Constants.getVal(Constants.F_CONTENT), null);
                    bigTitle = mData.getString(Constants.getVal(Constants.F_BIG_TITLE));
                    bigContent = mData.getString(Constants.getVal(Constants.F_BIG_CONTENT));
                    iconUrl = mData.getString(Constants.getVal(Constants.F_ICON_URL));
                    bigIconUrl = mData.getString(Constants.getVal(Constants.F_BIG_ICON_URL));
                    buttons = mData.getListPack(Constants.getVal(Constants.F_BUTTONS));
                }


                boolean hasBigTitle = bigTitle != null && !bigTitle.isEmpty();
                boolean hasBigContent = bigContent != null && !bigContent.isEmpty();
                boolean hasBigIcon = bigIconUrl != null && !bigIconUrl.isEmpty();

                builder.setTitle(hasBigTitle ? bigTitle : title);
                builder.setMessage(hasBigContent ? bigContent : content);

                // Set Dialog Icon  (Disabled For Now)
                // TODO: Implement showing icon in dialog
                /*String icon = hasBigIcon ? bigIconUrl : iconUrl;
                if (icon != null && !icon.isEmpty()) {
                    //builder.setIcon(new BitmapDrawable(getResources(), new ImageDownloader(context).downloadImage(icon)));
                    String mName = "ic_" + icon.replaceAll("[- ]", "_");
                    int resId0 = context.getResources().getIdentifier(mName, "drawable", context.getPackageName());
                    if(resId0 > 0){
                        builder.setIcon(resId0);
                    }
                    else{
                        builder.setIcon(context.getApplicationInfo().icon);
                    }
                }*/

                // Set Dialog buttons and button actions

                int buttonNumber = 0;
                if (buttons != null) {
                    List<NotificationDownstreamMessage.Button> buttonList =
                            new NotificationDownstreamMessage.Factory.NotificationButtonFactory().buildButtonsFromListPack(mData, buttons);
                    for (final NotificationDownstreamMessage.Button button : buttonList) {
                        // Don't show Open Dialog actions in dialog buttons
                        if (button.getAction().getActionType() == ActionType.DIALOG) {
                            continue;
                        }

                        DialogInterface.OnClickListener clickListener = new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                                saveInputData();
                                executeActionAndClose(ctx, button.getAction());
                                if (alertDialog.isShowing()) {
                                    alertDialog.dismiss();
                                }
                                setDialogShowing(false);
                            }
                        };

                        switch (buttonNumber++) {
                            case 0:
                                builder.setNegativeButton(button.getText(), clickListener);
                                break;

                            case 1:
                                builder.setPositiveButton(button.getText(), clickListener);
                                break;

                            case 2:
                                builder.setNeutralButton(button.getText(), clickListener);
                                break;

                            default:
                                //do nothing
                                break;
                        }
                    }
                }

                if (buttonNumber == 0) {
                    builder.setNegativeButton(R.string.pushpole_close_dialog, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            executeActionAndClose(ctx, null);
                            setDialogShowing(false);
                        }
                    });
                }

                builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
                    public void onCancel(DialogInterface dialog) {
                        setDialogShowing(false);
                        finish();
                    }
                });

                //Add inputs in case that this is an input dialog
                input1Lable = mData.getString(Constants.getVal(Constants.F_DIALOG_INPUT_1), "");
                input2Lable = mData.getString(Constants.getVal(Constants.F_DIALOG_INPUT_2), "");
                if (!input1Lable.isEmpty() || !input2Lable.isEmpty()) {
                    isInputDialog = true;
                    LinearLayout ll = new LinearLayout(context);
                    if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
                        ll.setLayoutParams(new ActionBar.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));
                    ll.setOrientation(LinearLayout.VERTICAL);

                    if (!input1Lable.isEmpty()) {
                        TextView lable1 = new TextView(context);
                        lable1.setText(input1Lable);
                        lable1.setGravity(Gravity.CENTER);

                        editText1 = new EditText(context);
                        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                                LinearLayout.LayoutParams.MATCH_PARENT,
                                LinearLayout.LayoutParams.MATCH_PARENT);
                        editText1.setLayoutParams(lp);
                        editText1.setGravity(Gravity.CENTER);

                        ll.addView(lable1);
                        ll.addView(editText1);
                    }

                    if (!input2Lable.isEmpty()) {
                        TextView lable2 = new TextView(context);
                        lable2.setText(input2Lable);
                        lable2.setGravity(Gravity.CENTER);
                        editText2 = new EditText(context);
                        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                                LinearLayout.LayoutParams.MATCH_PARENT,
                                LinearLayout.LayoutParams.MATCH_PARENT);
                        editText2.setLayoutParams(lp);
                        editText2.setGravity(Gravity.CENTER);

                        ll.addView(lable2);
                        ll.addView(editText2);

                    }
                    builder.setView(ll);

                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        alertDialog = builder.create();
                        alertDialog.show();
                    }
                });
            }
        });

    }

    private void saveInputData(){
        if(isInputDialog) {
            String userInput1 = editText1.getText().toString();
            String userInput2 = editText2.getText().toString();
            Pack p = new Pack();
            p.putString(input1Lable, userInput1);
            p.putString(input2Lable, userInput2);
            p.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));
            p.putString(Constants.getVal(Constants.F_ORIGINAL_MESSAGE_ID),
                    mData.getString(Constants.getVal(Constants.F_ORIGINAL_MESSAGE_ID)));
            SendManager.getInstance(getApplicationContext()).send(Constants.getVal(Constants.USER_INPUT_T), p);
        }
    }

    private void executeActionAndClose(Context context, final Action action) {
        finish();
        if (action != null) {
            TaskManager.getInstance(context).asyncTask(new PushPoleAsyncTask() {
                @Override
                public void run(Context context) {
                    action.execute(context);
                }
            });
        }
    }

}
