package com.pushpole.sdk.action.actions;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.activities.PopupDialogActivity;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PackBundler;

/**
 * Open Dialog Action; shows the notification in a dialog.
 */
public class DialogAction extends Action {
    private Pack mData;


    /**
     * create an intent to show dialog
     * if the latest dialog is not closed, does not show new dialog
     *
     * @param context the application context.
     */
    @Override
    public void execute(final Context context) {
        // TODO: below chack is disabled for backward compatibility
        //if(mData.containsKey(Constants.F_DTITLE) || mData.containsKey(Constants.F_DCONTENT)){
        if (!PopupDialogActivity.isDialogShowing()) {
            PopupDialogActivity.setDialogShowing(true);
            Intent intent = new Intent(context, PopupDialogActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

            intent.putExtras(PackBundler.packToBundle(mData));
            intent.setAction(PlainConstants.ACTION_OPEN_DIALOG);
            context.startActivity(intent);
        }
        //}
    }

    /**
     * return type
     *
     * @return {@code ActionType.DIALOG}
     */
    @Override
    public ActionType getActionType() {
        return ActionType.DIALOG;
    }

    /**
     * serialize to {@link Pack}
     *
     * @return
     */
    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putAll(mData);
        return pack;
    }

    /**
     * Factory class to generate {@link DialogAction} instance
     */
    public static class Factory extends ActionFactory {

        /**
         * generate {@link DialogAction} instance
         *
         * @param data the data to create the {@code Action} with given as a {@link Pack}
         * @return
         */
        @Override
        public Action buildAction(Pack data) {
            DialogAction action = new DialogAction();

            action.mData = new Pack(data);

            return action;
        }
    }
}
