package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

public class UpdateConfigMessage extends DownstreamMessage {

    private Pack update;
    private ListPack remove;

    @Override
    public Type getMessageType() {
        return Type.UPDATE_CONFIG;
    }
    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            UpdateConfigMessage configMessage = new UpdateConfigMessage();
            configMessage.update = data.getPack("update");
            configMessage.remove = data.getListPack("remove");
            return configMessage;
        }
    }

    public Pack getUpdates() {
        try {
            return update;
        } catch (Exception e) {
            return null;
        }
    }

    public String getRemoveKeys() {
        try {
            return remove.toString();
        } catch (Exception e) {
            return null;
        }
    }
}
