package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;

import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-08-01, 4:56 PM.
 *
 * @author Akram Shokri
 */

public class SendPushNotifReceiversController implements DownstreamApiController {

    private Context mContext;

    public SendPushNotifReceiversController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        SendManager.getInstance(mContext).send(Constants.getVal(Constants.SEND_PUSH_NOTIF_RECEIVERS_T), getAllPushPoleReceivers());
    }

    private Pack getAllPushPoleReceivers(){

        PackageManager packageManager = mContext.getPackageManager();
        Intent intent = new Intent("com.google.android.c2dm.intent.RECEIVE");
        List<ResolveInfo> activities = packageManager.queryBroadcastReceivers(intent, 0);

        ListPack listPack = new ListPack();
        for (ResolveInfo resolveInfo : activities) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo != null
                    && activityInfo.packageName.equals(mContext.getPackageName())) {
                listPack.addString(activityInfo.name );
            }
        }
        Pack pack = new Pack();
        pack.putListPack(Constants.getVal(Constants.PUSH_NOTIF_RECEIVERS_NAME), listPack);
       try {
           PackageInfo pInfo = mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0);
           pack.putString(Constants.getVal(Constants.PUSH_NOTIF_RECEIVERS_APP_VERSION), pInfo.versionName);
           pack.putInt(Constants.getVal(Constants.PUSH_NOTIF_RECEIVERS_APP_VERSION_CODE), pInfo.versionCode);
       }catch (PackageManager.NameNotFoundException e) {
           Logger.warning("retrieving app version failed.");
       }
        return pack;
    }
}
