package com.pushpole.sdk.controller;

import android.content.Context;

/**
 * Factory class to generate {DownstreamApiController} instance
 * When creating a new {@link DownstreamApiFactory}, implement this class to create instances of your {@link DownstreamApiController}
 */
public interface DownstreamApiFactory {
    /**
     * Builds an {@link DownstreamApiController} instance .
     * <p>
     * Override this method to create instances of your {@link DownstreamApiController}.
     *
     * @param context the app context
     * @return the new instance of the {@link DownstreamApiController}
     */
    DownstreamApiController buildDownstreamHandler(Context context);
}
