/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PrivateEncryptedChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.util.HttpChannelAuthorizer;

public class PrivateEncryptedChannelExampleApp {
    private String channelsKey = "FILL_ME_IN";
    private String channelName = "private-encrypted-channel";
    private String eventName = "my-event";
    private String cluster = "eu";
    private final String channelAuthorizationEndpoint = "http://localhost:3030/pusher/auth";

    public static void main(String[] args) {
        new PrivateEncryptedChannelExampleApp(args);
    }

    private PrivateEncryptedChannelExampleApp(String[] args) {
        switch (args.length) {
            case 4: {
                this.cluster = args[3];
            }
            case 3: {
                this.eventName = args[2];
            }
            case 2: {
                this.channelName = args[1];
            }
            case 1: {
                this.channelsKey = args[0];
            }
        }
        HttpChannelAuthorizer channelAuthorizer = new HttpChannelAuthorizer("http://localhost:3030/pusher/auth");
        PusherOptions options = new PusherOptions().setCluster(this.cluster).setChannelAuthorizer(channelAuthorizer).setUseTLS(true);
        Pusher pusher = new Pusher(this.channelsKey, options);
        ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

            @Override
            public void onConnectionStateChange(ConnectionStateChange change) {
                System.out.printf("Connection state changed from [%s] to [%s]%n", new Object[]{change.getPreviousState(), change.getCurrentState()});
            }

            @Override
            public void onError(String message, String code, Exception e) {
                System.out.printf("An error was received with message [%s], code [%s], exception [%s]%n", message, code, e);
            }
        };
        pusher.connect(connectionEventListener, new ConnectionState[0]);
        PrivateEncryptedChannelEventListener privateEncryptedChannelEventListener = new PrivateEncryptedChannelEventListener(){

            @Override
            public void onSubscriptionSucceeded(String channelName) {
                System.out.printf("Subscription to channel [%s] succeeded%n", channelName);
            }

            @Override
            public void onEvent(PusherEvent event) {
                System.out.printf("Received event [%s]%n", event.toString());
            }

            @Override
            public void onAuthenticationFailure(String message, Exception e) {
                System.out.printf("Authorization failure due to [%s], exception was [%s]%n", message, e);
            }

            @Override
            public void onDecryptionFailure(String event, String reason) {
                System.out.printf("An error was received decrypting message for event:[%s] - reason: [%s]%n", event, reason);
            }
        };
        pusher.subscribePrivateEncrypted(this.channelName, privateEncryptedChannelEventListener, this.eventName);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

