/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.connection.websocket;

import com.google.gson.Gson;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.connection.websocket.WebSocketClientWrapper;
import com.pusher.client.connection.websocket.WebSocketListener;
import com.pusher.client.util.Factory;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketConnection
implements InternalConnection,
WebSocketListener {
    private static final Logger log = Logger.getLogger(WebSocketConnection.class.getName());
    private static final Gson GSON = new Gson();
    private static final String PING_EVENT_SERIALIZED = "{\"event\": \"pusher:ping\"}";
    private final Factory factory;
    private final ActivityTimer activityTimer;
    private final Map<ConnectionState, Set<ConnectionEventListener>> eventListeners = new ConcurrentHashMap<ConnectionState, Set<ConnectionEventListener>>();
    private final URI webSocketUri;
    private final Proxy proxy;
    private final int maxReconnectionAttempts;
    private final int maxReconnectionGap;
    private volatile ConnectionState state = ConnectionState.DISCONNECTED;
    private WebSocketClientWrapper underlyingConnection;
    private final Consumer<PusherEvent> eventHandler;
    private String socketId;
    private int reconnectAttempts = 0;

    public WebSocketConnection(String url, long activityTimeout, long pongTimeout, int maxReconnectionAttempts, int maxReconnectionGap, Proxy proxy, Consumer<PusherEvent> eventHandler, Factory factory) throws URISyntaxException {
        this.webSocketUri = new URI(url);
        this.activityTimer = new ActivityTimer(activityTimeout, pongTimeout);
        this.maxReconnectionAttempts = maxReconnectionAttempts;
        this.maxReconnectionGap = maxReconnectionGap;
        this.proxy = proxy;
        this.factory = factory;
        this.eventHandler = eventHandler;
        for (ConnectionState state : ConnectionState.values()) {
            this.eventListeners.put(state, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    @Override
    public void connect() {
        this.factory.queueOnEventThread(() -> {
            if (this.canConnect()) {
                this.tryConnecting();
            }
        });
    }

    private void tryConnecting() {
        try {
            this.underlyingConnection = this.factory.newWebSocketClientWrapper(this.webSocketUri, this.proxy, this);
            this.updateState(ConnectionState.CONNECTING);
            this.underlyingConnection.connect();
        }
        catch (SSLException e) {
            this.sendErrorToAllListeners("Error connecting over SSL", null, e);
        }
    }

    @Override
    public void disconnect() {
        this.factory.queueOnEventThread(() -> {
            if (this.canDisconnect()) {
                this.updateState(ConnectionState.DISCONNECTING);
                this.underlyingConnection.close();
            }
        });
    }

    @Override
    public void bind(ConnectionState state, ConnectionEventListener eventListener) {
        this.eventListeners.get((Object)state).add(eventListener);
    }

    @Override
    public boolean unbind(ConnectionState state, ConnectionEventListener eventListener) {
        return this.eventListeners.get((Object)state).remove(eventListener);
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public void sendMessage(String message) {
        this.factory.queueOnEventThread(() -> {
            try {
                if (this.state == ConnectionState.CONNECTED) {
                    this.underlyingConnection.send(message);
                } else {
                    this.sendErrorToAllListeners("Cannot send a message while in " + (Object)((Object)this.state) + " state", null, null);
                }
            }
            catch (Exception e) {
                this.sendErrorToAllListeners("An exception occurred while sending message [" + message + "]", null, e);
            }
        });
    }

    @Override
    public String getSocketId() {
        return this.socketId;
    }

    private void updateState(ConnectionState newState) {
        log.fine("State transition requested, current [" + (Object)((Object)this.state) + "], new [" + (Object)((Object)newState) + "]");
        ConnectionStateChange change = new ConnectionStateChange(this.state, newState);
        this.state = newState;
        HashSet interestedListeners = new HashSet();
        interestedListeners.addAll(this.eventListeners.get((Object)ConnectionState.ALL));
        interestedListeners.addAll(this.eventListeners.get((Object)newState));
        for (ConnectionEventListener listener : interestedListeners) {
            this.factory.queueOnEventThread(() -> listener.onConnectionStateChange(change));
        }
    }

    private void handleEvent(PusherEvent event) {
        if (event.getEventName().equals("pusher:connection_established")) {
            this.handleConnectihandleEvent(event);
        } else if (event.getEventName().equals("pusher:error")) {
            this.handleError(event);
        }
        this.eventHandler.accept(event);
    }

    private void handleConnectihandleEvent(PusherEvent event) {
        Map dataMap = (Map)GSON.fromJson(event.getData(), Map.class);
        this.socketId = (String)dataMap.get("socket_id");
        if (this.state != ConnectionState.CONNECTED) {
            this.updateState(ConnectionState.CONNECTED);
        }
        this.reconnectAttempts = 0;
    }

    private void handleError(PusherEvent event) {
        Map dataMap = (Map)GSON.fromJson(event.getData(), Map.class);
        String message = (String)dataMap.get("message");
        Object codeObject = dataMap.get("code");
        String code = null;
        if (codeObject != null) {
            code = String.valueOf(Math.round((Double)codeObject));
        }
        this.sendErrorToAllListeners(message, code, null);
    }

    private void sendErrorToAllListeners(String message, String code, Exception e) {
        HashSet<ConnectionEventListener> allListeners = new HashSet<ConnectionEventListener>();
        for (Set<ConnectionEventListener> listenersForState : this.eventListeners.values()) {
            allListeners.addAll(listenersForState);
        }
        for (ConnectionEventListener listener : allListeners) {
            this.factory.queueOnEventThread(() -> listener.onError(message, code, e));
        }
    }

    @Override
    public void onOpen(ServerHandshake handshakeData) {
    }

    @Override
    public void onMessage(String message) {
        this.activityTimer.activity();
        this.factory.queueOnEventThread(() -> this.handleEvent(PusherEvent.fromJson(message)));
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        if (this.state == ConnectionState.DISCONNECTED || this.state == ConnectionState.RECONNECTING) {
            log.warning("Received close from underlying socket when already disconnected.Close code [" + code + "], Reason [" + reason + "], Remote [" + remote + "]");
            return;
        }
        if (!this.shouldReconnect(code)) {
            this.updateState(ConnectionState.DISCONNECTING);
        }
        if (this.state == ConnectionState.CONNECTED || this.state == ConnectionState.CONNECTING) {
            if (this.reconnectAttempts < this.maxReconnectionAttempts) {
                this.tryReconnecting();
            } else {
                this.updateState(ConnectionState.DISCONNECTING);
                this.cancelTimeoutsAndTransitionToDisconnected();
            }
            return;
        }
        if (this.state == ConnectionState.DISCONNECTING) {
            this.cancelTimeoutsAndTransitionToDisconnected();
        }
    }

    private void tryReconnecting() {
        ++this.reconnectAttempts;
        this.updateState(ConnectionState.RECONNECTING);
        long reconnectInterval = Math.min(this.maxReconnectionGap, this.reconnectAttempts * this.reconnectAttempts);
        this.factory.getTimers().schedule(() -> {
            if (this.state == ConnectionState.RECONNECTING) {
                this.underlyingConnection.removeWebSocketListener();
                this.tryConnecting();
            }
        }, reconnectInterval, TimeUnit.SECONDS);
    }

    private boolean shouldReconnect(int code) {
        return code < 4000 || code >= 4100;
    }

    private void cancelTimeoutsAndTransitionToDisconnected() {
        this.activityTimer.cancelTimeouts();
        this.factory.queueOnEventThread(() -> {
            if (this.state == ConnectionState.DISCONNECTING) {
                this.updateState(ConnectionState.DISCONNECTED);
                this.factory.shutdownThreads();
            }
        });
        this.reconnectAttempts = 0;
    }

    @Override
    public void onError(Exception ex) {
        this.factory.queueOnEventThread(() -> this.sendErrorToAllListeners("An exception was thrown by the websocket", null, ex));
    }

    private boolean canConnect() {
        return this.state == ConnectionState.DISCONNECTING || this.state == ConnectionState.DISCONNECTED;
    }

    private boolean canDisconnect() {
        return this.state != ConnectionState.DISCONNECTING && this.state != ConnectionState.DISCONNECTED;
    }

    private class ActivityTimer {
        private final long activityTimeout;
        private final long pongTimeout;
        private Future<?> pingTimer;
        private Future<?> pongTimer;

        ActivityTimer(long activityTimeout, long pongTimeout) {
            this.activityTimeout = activityTimeout;
            this.pongTimeout = pongTimeout;
        }

        synchronized void activity() {
            if (this.pongTimer != null) {
                this.pongTimer.cancel(true);
            }
            if (this.pingTimer != null) {
                this.pingTimer.cancel(false);
            }
            this.pingTimer = WebSocketConnection.this.factory.getTimers().schedule(() -> {
                log.fine("Sending ping");
                WebSocketConnection.this.sendMessage(WebSocketConnection.PING_EVENT_SERIALIZED);
                this.schedulePongCheck();
            }, this.activityTimeout, TimeUnit.MILLISECONDS);
        }

        synchronized void cancelTimeouts() {
            if (this.pingTimer != null) {
                this.pingTimer.cancel(false);
            }
            if (this.pongTimer != null) {
                this.pongTimer.cancel(false);
            }
        }

        private synchronized void schedulePongCheck() {
            if (this.pongTimer != null) {
                this.pongTimer.cancel(false);
            }
            this.pongTimer = WebSocketConnection.this.factory.getTimers().schedule(() -> {
                log.fine("Timed out awaiting pong from server - disconnecting");
                WebSocketConnection.this.underlyingConnection.removeWebSocketListener();
                WebSocketConnection.this.underlyingConnection.close();
                WebSocketConnection.this.onClose(-1, "Pong timeout", false);
            }, this.pongTimeout, TimeUnit.MILLISECONDS);
        }
    }
}

