/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import com.pusher.client.ChannelAuthorizer;
import com.pusher.client.UserAuthenticator;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Properties;

public class PusherOptions {
    private static final String SRC_LIB_DEV_VERSION = "@version@";
    private static final String LIB_DEV_VERSION = "0.0.0-dev";
    public static final String LIB_VERSION = PusherOptions.readVersionFromProperties();
    private static final String URI_SUFFIX = "?client=java-client&protocol=5&version=" + LIB_VERSION;
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final int WS_PORT = 80;
    private static final int WSS_PORT = 443;
    private static final String PUSHER_DOMAIN = "pusher.com";
    private static final long DEFAULT_ACTIVITY_TIMEOUT = 120000L;
    private static final long DEFAULT_PONG_TIMEOUT = 30000L;
    private static final int MAX_RECONNECTION_ATTEMPTS = 6;
    private static final int MAX_RECONNECT_GAP_IN_SECONDS = 30;
    private String host = "ws.pusherapp.com";
    private int wsPort = 80;
    private int wssPort = 443;
    private boolean useTLS = true;
    private long activityTimeout = 120000L;
    private long pongTimeout = 30000L;
    private UserAuthenticator userAuthenticator;
    private ChannelAuthorizer channelAuthorizer;
    private Authorizer authorizer;
    private Proxy proxy = Proxy.NO_PROXY;
    private int maxReconnectionAttempts = 6;
    private int maxReconnectGapInSeconds = 30;

    @Deprecated
    public boolean isEncrypted() {
        return this.useTLS;
    }

    @Deprecated
    public PusherOptions setEncrypted(boolean encrypted) {
        this.useTLS = encrypted;
        return this;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public PusherOptions setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
        return this;
    }

    public UserAuthenticator getUserAuthenticator() {
        return this.userAuthenticator;
    }

    public PusherOptions setUserAuthenticator(UserAuthenticator userAuthenticator) {
        this.userAuthenticator = userAuthenticator;
        return this;
    }

    public ChannelAuthorizer getChannelAuthorizer() {
        return this.channelAuthorizer;
    }

    public PusherOptions setChannelAuthorizer(ChannelAuthorizer channelAuthorizer) {
        this.channelAuthorizer = channelAuthorizer;
        return this;
    }

    @Deprecated
    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    @Deprecated
    public PusherOptions setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this.setChannelAuthorizer(authorizer);
    }

    public PusherOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public PusherOptions setWsPort(int wsPort) {
        this.wsPort = wsPort;
        return this;
    }

    public PusherOptions setWssPort(int wssPort) {
        this.wssPort = wssPort;
        return this;
    }

    public PusherOptions setCluster(String cluster) {
        this.host = "ws-" + cluster + "." + PUSHER_DOMAIN;
        this.wsPort = 80;
        this.wssPort = 443;
        return this;
    }

    public PusherOptions setActivityTimeout(long activityTimeout) {
        if (activityTimeout < 1000L) {
            throw new IllegalArgumentException("Activity timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.activityTimeout = activityTimeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public PusherOptions setPongTimeout(long pongTimeout) {
        if (pongTimeout < 1000L) {
            throw new IllegalArgumentException("Pong timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.pongTimeout = pongTimeout;
        return this;
    }

    public PusherOptions setMaxReconnectionAttempts(int maxReconnectionAttempts) {
        this.maxReconnectionAttempts = maxReconnectionAttempts;
        return this;
    }

    public PusherOptions setMaxReconnectGapInSeconds(int maxReconnectGapInSeconds) {
        this.maxReconnectGapInSeconds = maxReconnectGapInSeconds;
        return this;
    }

    public long getPongTimeout() {
        return this.pongTimeout;
    }

    public String buildUrl(String apiKey) {
        return String.format("%s://%s:%s/app/%s%s", this.useTLS ? WSS_SCHEME : WS_SCHEME, this.host, this.useTLS ? this.wssPort : this.wsPort, apiKey, URI_SUFFIX);
    }

    public PusherOptions setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy must not be null (instead use Proxy.NO_PROXY)");
        }
        this.proxy = proxy;
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getMaxReconnectionAttempts() {
        return this.maxReconnectionAttempts;
    }

    public int getMaxReconnectGapInSeconds() {
        return this.maxReconnectGapInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersionFromProperties() {
        InputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = PusherOptions.class.getResourceAsStream("/pusher.properties");
            p.load(inStream);
            String version = (String)p.get("version");
            if (version.equals(SRC_LIB_DEV_VERSION)) {
                version = LIB_DEV_VERSION;
            }
            if (version != null && version.length() > 0) {
                String string = version;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "0.0.0";
    }
}

