/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class PusherEvent {
    private JsonObject jsonObject = new JsonObject();

    public Object getProperty(String key) {
        switch (key) {
            case "user_id": {
                return this.getUserId();
            }
            case "channel": {
                return this.getChannelName();
            }
            case "data": {
                return this.jsonObject.get("data");
            }
            case "event": {
                return this.getEventName();
            }
        }
        return null;
    }

    public String getUserId() {
        return this.jsonObject.has("user_id") ? this.jsonObject.get("user_id").getAsString() : null;
    }

    public String getChannelName() {
        return this.jsonObject.has("channel") ? this.jsonObject.get("channel").getAsString() : null;
    }

    public String getEventName() {
        return this.jsonObject.has("event") ? this.jsonObject.get("event").getAsString() : null;
    }

    public String getData() {
        JsonElement data = this.jsonObject.get("data");
        if (data.isJsonPrimitive()) {
            return data.getAsString();
        }
        Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
        return gson.toJson(data);
    }

    public String toString() {
        return this.toJson();
    }

    public PusherEvent(String event, String channel, String userId, String data) {
        this.jsonObject.addProperty("event", event);
        this.jsonObject.addProperty("channel", channel);
        this.jsonObject.addProperty("userId", userId);
        this.jsonObject.addProperty("data", data);
    }

    public PusherEvent(String event, String channel, String userId, Map<String, Object> data) {
        this(event, channel, userId, new Gson().toJson(data));
    }

    public PusherEvent(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((JsonElement)this.jsonObject);
    }

    public static PusherEvent fromJson(String json) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return new PusherEvent((JsonObject)gson.fromJson(json, JsonObject.class));
    }
}

