/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.User;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PresenceChannelImpl
extends PrivateChannelImpl
implements PresenceChannel {
    private static final String MEMBER_ADDED_EVENT = "pusher_internal:member_added";
    private static final String MEMBER_REMOVED_EVENT = "pusher_internal:member_removed";
    private static final Gson GSON = new Gson();
    private final Map<String, User> idToUserMap = Collections.synchronizedMap(new LinkedHashMap());
    private String myUserID;

    public PresenceChannelImpl(InternalConnection connection, String channelName, Authorizer authorizer, Factory factory) {
        super(connection, channelName, authorizer, factory);
    }

    @Override
    public Set<User> getUsers() {
        return new LinkedHashSet<User>(this.idToUserMap.values());
    }

    @Override
    public User getMe() {
        return this.idToUserMap.get(this.myUserID);
    }

    @Override
    public void onMessage(String event, String message) {
        super.onMessage(event, message);
        if (event.equals("pusher_internal:subscription_succeeded")) {
            this.handleSubscriptionSuccessfulMessage(message);
        } else if (event.equals(MEMBER_ADDED_EVENT)) {
            this.handleMemberAddedEvent(message);
        } else if (event.equals(MEMBER_REMOVED_EVENT)) {
            this.handleMemberRemovedEvent(message);
        }
    }

    @Override
    public String toSubscribeMessage() {
        String msg = super.toSubscribeMessage();
        this.myUserID = this.extractUserIdFromChannelData(this.channelData);
        return msg;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PresenceChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PresenceChannelEventListener can be bound to a presence channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!presence-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Presence Channel: name=%s]", this.name);
    }

    private void handleSubscriptionSuccessfulMessage(String message) {
        ChannelEventListener listener = this.getEventListener();
        PresenceData presenceData = PresenceChannelImpl.extractPresenceDataFrom(message);
        if (presenceData == null) {
            if (listener != null) {
                listener.onError("Subscription failed: Presence data not found", null);
            }
            return;
        }
        List<String> ids = presenceData.ids;
        Map<String, Object> hash = presenceData.hash;
        if (ids != null && !ids.isEmpty()) {
            for (String id : ids) {
                String userData = hash.get(id) != null ? GSON.toJson(hash.get(id)) : null;
                User user = new User(id, userData);
                this.idToUserMap.put(id, user);
            }
        }
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.onUsersInformationReceived(this.getName(), this.getUsers());
        }
    }

    private void handleMemberAddedEvent(String message) {
        String dataString = PresenceChannelImpl.extractDataStringFrom(message);
        MemberData memberData = (MemberData)GSON.fromJson(dataString, MemberData.class);
        String id = memberData.userId;
        String userData = memberData.userInfo != null ? GSON.toJson(memberData.userInfo) : null;
        User user = new User(id, userData);
        this.idToUserMap.put(id, user);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userSubscribed(this.getName(), user);
        }
    }

    private void handleMemberRemovedEvent(String message) {
        String dataString = PresenceChannelImpl.extractDataStringFrom(message);
        MemberData memberData = (MemberData)GSON.fromJson(dataString, MemberData.class);
        User user = this.idToUserMap.remove(memberData.userId);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userUnsubscribed(this.getName(), user);
        }
    }

    private static String extractDataStringFrom(String message) {
        Map jsonObject = (Map)GSON.fromJson(message, Map.class);
        return (String)jsonObject.get("data");
    }

    private static PresenceData extractPresenceDataFrom(String message) {
        String dataString = PresenceChannelImpl.extractDataStringFrom(message);
        return ((Presence)PresenceChannelImpl.GSON.fromJson((String)dataString, Presence.class)).presence;
    }

    private String extractUserIdFromChannelData(String channelData) {
        Object maybeUserId;
        Map channelDataMap;
        try {
            channelDataMap = (Map)GSON.fromJson(channelData, Map.class);
        }
        catch (JsonSyntaxException e) {
            throw new AuthorizationFailureException("Invalid response from Authorizer: unable to parse channel_data object: " + channelData, (Exception)((Object)e));
        }
        try {
            maybeUserId = channelDataMap.get("user_id");
        }
        catch (NullPointerException e) {
            throw new AuthorizationFailureException("Invalid response from Authorizer: no user_id key in channel_data object: " + channelData);
        }
        if (maybeUserId == null) {
            throw new AuthorizationFailureException("Invalid response from Authorizer: no user_id key in channel_data object: " + channelData);
        }
        return String.valueOf(maybeUserId);
    }

    private class Presence {
        @SerializedName(value="presence")
        public PresenceData presence;

        private Presence() {
        }
    }

    private class PresenceData {
        @SerializedName(value="count")
        public Integer count;
        @SerializedName(value="ids")
        public List<String> ids;
        @SerializedName(value="hash")
        public Map<String, Object> hash;

        private PresenceData() {
        }
    }

    private class MemberData {
        @SerializedName(value="user_id")
        public String userId;
        @SerializedName(value="user_info")
        public Object userInfo;

        private MemberData() {
        }
    }
}

