/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.crypto.nacl;

import com.pusher.client.crypto.nacl.AuthenticityException;
import com.pusher.client.crypto.nacl.Poly1305;
import com.pusher.client.crypto.nacl.Salsa;
import com.pusher.client.util.internal.Preconditions;
import java.util.Arrays;

public class SecretBoxOpener {
    private static final int OVERHEAD = 16;
    private byte[] key;

    public SecretBoxOpener(byte[] key) {
        Preconditions.checkNotNull(key, "null key passed");
        Preconditions.checkArgument(key.length == 32, "key length must be 32 bytes, but is " + key.length + " bytes");
        this.key = key;
    }

    public byte[] open(byte[] box, byte[] nonce) throws AuthenticityException {
        Preconditions.checkNotNull(this.key, "key has been cleared, create new instance");
        Preconditions.checkArgument(nonce.length == 24, "nonce length must be 24 bytes, but is " + this.key.length + " bytes");
        byte[] subKey = new byte[32];
        byte[] counter = new byte[16];
        this.setup(subKey, counter, nonce, this.key);
        byte[] firstBlock = new byte[64];
        firstBlock = Salsa.XORKeyStream(firstBlock, counter, subKey);
        byte[] poly1305Key = new byte[32];
        System.arraycopy(firstBlock, 0, poly1305Key, 0, poly1305Key.length);
        byte[] tag = new byte[16];
        System.arraycopy(box, 0, tag, 0, tag.length);
        byte[] cipher = new byte[box.length - 16];
        System.arraycopy(box, 16, cipher, 0, cipher.length);
        if (!Poly1305.verify(tag, cipher, poly1305Key)) {
            throw new AuthenticityException();
        }
        byte[] ret = new byte[box.length - 16];
        System.arraycopy(box, 16, ret, 0, ret.length);
        byte[] firstMessageBlock = new byte[ret.length];
        if (ret.length > 32) {
            firstMessageBlock = new byte[32];
        }
        System.arraycopy(ret, 0, firstMessageBlock, 0, firstMessageBlock.length);
        for (int i = 0; i < firstMessageBlock.length; ++i) {
            ret[i] = (byte)(firstBlock[32 + i] ^ firstMessageBlock[i]);
        }
        counter[8] = 1;
        byte[] newbox = new byte[box.length - (firstMessageBlock.length + 16)];
        for (int i = 0; i < newbox.length; ++i) {
            newbox[i] = box[i + firstMessageBlock.length + 16];
        }
        byte[] rest = Salsa.XORKeyStream(newbox, counter, subKey);
        System.arraycopy(rest, 0, ret, firstMessageBlock.length, ret.length - firstMessageBlock.length);
        return ret;
    }

    public void clearKey() {
        Arrays.fill(this.key, (byte)0);
        if (this.key[0] != 0) {
            throw new SecurityException("key not cleared correctly");
        }
        this.key = null;
    }

    private void setup(byte[] subKey, byte[] counter, byte[] nonce, byte[] key) {
        byte[] hNonce = new byte[16];
        System.arraycopy(nonce, 0, hNonce, 0, hNonce.length);
        byte[] newSubKey = Salsa.HSalsa20(hNonce, key, Salsa.SIGMA);
        System.arraycopy(newSubKey, 0, subKey, 0, subKey.length);
        System.arraycopy(nonce, 16, counter, 0, nonce.length - 16);
    }
}

