/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.crypto.nacl;

public class Salsa {
    public static final byte[] SIGMA = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
    private static final int ROUNDS = 20;

    private static long mask(byte x) {
        return 0xFFL & (long)x;
    }

    public static byte[] core(byte[] in, byte[] k, byte[] c) {
        byte[] out = new byte[64];
        long mask = 0xFFFFFFFFL;
        long j0 = mask & (Salsa.mask(c[0]) | Salsa.mask(c[1]) << 8 | Salsa.mask(c[2]) << 16 | Salsa.mask(c[3]) << 24);
        long j1 = mask & (Salsa.mask(k[0]) | Salsa.mask(k[1]) << 8 | Salsa.mask(k[2]) << 16 | Salsa.mask(k[3]) << 24);
        long j2 = mask & (Salsa.mask(k[4]) | Salsa.mask(k[5]) << 8 | Salsa.mask(k[6]) << 16 | Salsa.mask(k[7]) << 24);
        long j3 = mask & (Salsa.mask(k[8]) | Salsa.mask(k[9]) << 8 | Salsa.mask(k[10]) << 16 | Salsa.mask(k[11]) << 24);
        long j4 = mask & (Salsa.mask(k[12]) | Salsa.mask(k[13]) << 8 | Salsa.mask(k[14]) << 16 | Salsa.mask(k[15]) << 24);
        long j5 = mask & (Salsa.mask(c[4]) | Salsa.mask(c[5]) << 8 | Salsa.mask(c[6]) << 16 | Salsa.mask(c[7]) << 24);
        long j6 = mask & (Salsa.mask(in[0]) | Salsa.mask(in[1]) << 8 | Salsa.mask(in[2]) << 16 | Salsa.mask(in[3]) << 24);
        long j7 = mask & (Salsa.mask(in[4]) | Salsa.mask(in[5]) << 8 | Salsa.mask(in[6]) << 16 | Salsa.mask(in[7]) << 24);
        long j8 = mask & (Salsa.mask(in[8]) | Salsa.mask(in[9]) << 8 | Salsa.mask(in[10]) << 16 | Salsa.mask(in[11]) << 24);
        long j9 = mask & (Salsa.mask(in[12]) | Salsa.mask(in[13]) << 8 | Salsa.mask(in[14]) << 16 | Salsa.mask(in[15]) << 24);
        long j10 = mask & (Salsa.mask(c[8]) | Salsa.mask(c[9]) << 8 | Salsa.mask(c[10]) << 16 | Salsa.mask(c[11]) << 24);
        long j11 = mask & (Salsa.mask(k[16]) | Salsa.mask(k[17]) << 8 | Salsa.mask(k[18]) << 16 | Salsa.mask(k[19]) << 24);
        long j12 = mask & (Salsa.mask(k[20]) | Salsa.mask(k[21]) << 8 | Salsa.mask(k[22]) << 16 | Salsa.mask(k[23]) << 24);
        long j13 = mask & (Salsa.mask(k[24]) | Salsa.mask(k[25]) << 8 | Salsa.mask(k[26]) << 16 | Salsa.mask(k[27]) << 24);
        long j14 = mask & (Salsa.mask(k[28]) | Salsa.mask(k[29]) << 8 | Salsa.mask(k[30]) << 16 | Salsa.mask(k[31]) << 24);
        long j15 = mask & (Salsa.mask(c[12]) | Salsa.mask(c[13]) << 8 | Salsa.mask(c[14]) << 16 | Salsa.mask(c[15]) << 24);
        long x0 = j0;
        long x1 = j1;
        long x2 = j2;
        long x3 = j3;
        long x4 = j4;
        long x5 = j5;
        long x6 = j6;
        long x7 = j7;
        long x8 = j8;
        long x9 = j9;
        long x10 = j10;
        long x11 = j11;
        long x12 = j12;
        long x13 = j13;
        long x14 = j14;
        long x15 = j15;
        for (int i = 0; i < 20; i += 2) {
            long u = mask & x0 + x12;
            x4 ^= mask & (u << 7 | u >>> 25);
            u = mask & x4 + x0;
            x8 ^= mask & (u << 9 | u >>> 23);
            u = mask & x8 + x4;
            x12 ^= mask & (u << 13 | u >>> 19);
            u = mask & x12 + x8;
            x0 ^= mask & (u << 18 | u >>> 14);
            u = mask & x5 + x1;
            x9 ^= mask & (u << 7 | u >>> 25);
            u = mask & x9 + x5;
            x13 ^= mask & (u << 9 | u >>> 23);
            u = mask & x13 + x9;
            x1 ^= mask & (u << 13 | u >>> 19);
            u = mask & x1 + x13;
            x5 ^= mask & (u << 18 | u >>> 14);
            u = mask & x10 + x6;
            x14 ^= mask & (u << 7 | u >>> 25);
            u = mask & x14 + x10;
            x2 ^= mask & (u << 9 | u >>> 23);
            u = mask & x2 + x14;
            x6 ^= mask & (u << 13 | u >>> 19);
            u = mask & x6 + x2;
            x10 ^= mask & (u << 18 | u >>> 14);
            u = mask & x15 + x11;
            x3 ^= mask & (u << 7 | u >>> 25);
            u = mask & x3 + x15;
            x7 ^= mask & (u << 9 | u >>> 23);
            u = mask & x7 + x3;
            x11 ^= mask & (u << 13 | u >>> 19);
            u = mask & x11 + x7;
            x15 ^= mask & (u << 18 | u >>> 14);
            u = mask & x0 + x3;
            x1 ^= mask & (u << 7 | u >>> 25);
            u = mask & x1 + x0;
            x2 ^= mask & (u << 9 | u >>> 23);
            u = mask & x2 + x1;
            x3 ^= mask & (u << 13 | u >>> 19);
            u = mask & x3 + x2;
            x0 ^= mask & (u << 18 | u >>> 14);
            u = mask & x5 + x4;
            x6 ^= mask & (u << 7 | u >>> 25);
            u = mask & x6 + x5;
            x7 ^= mask & (u << 9 | u >>> 23);
            u = mask & x7 + x6;
            x4 ^= mask & (u << 13 | u >>> 19);
            u = mask & x4 + x7;
            x5 ^= mask & (u << 18 | u >>> 14);
            u = mask & x10 + x9;
            x11 ^= mask & (u << 7 | u >>> 25);
            u = mask & x11 + x10;
            x8 ^= mask & (u << 9 | u >>> 23);
            u = mask & x8 + x11;
            x9 ^= mask & (u << 13 | u >>> 19);
            u = mask & x9 + x8;
            x10 ^= mask & (u << 18 | u >>> 14);
            u = mask & x15 + x14;
            x12 ^= mask & (u << 7 | u >>> 25);
            u = mask & x12 + x15;
            x13 ^= mask & (u << 9 | u >>> 23);
            u = mask & x13 + x12;
            x14 ^= mask & (u << 13 | u >>> 19);
            u = mask & x14 + x13;
            x15 ^= mask & (u << 18 | u >>> 14);
        }
        x0 += j0;
        x1 += j1;
        x2 += j2;
        x3 += j3;
        x4 += j4;
        x5 += j5;
        x6 += j6;
        x7 += j7;
        x8 += j8;
        x9 += j9;
        x10 += j10;
        x11 += j11;
        x12 += j12;
        x13 += j13;
        x14 += j14;
        x15 += j15;
        x0 &= mask;
        x1 &= mask;
        x2 &= mask;
        x3 &= mask;
        x4 &= mask;
        x5 &= mask;
        x6 &= mask;
        x7 &= mask;
        x8 &= mask;
        x9 &= mask;
        x10 &= mask;
        x11 &= mask;
        x12 &= mask;
        x13 &= mask;
        x14 &= mask;
        x15 &= mask;
        out[0] = (byte)x0;
        out[1] = (byte)(x0 >> 8);
        out[2] = (byte)(x0 >> 16);
        out[3] = (byte)(x0 >> 24);
        out[4] = (byte)x1;
        out[5] = (byte)(x1 >> 8);
        out[6] = (byte)(x1 >> 16);
        out[7] = (byte)(x1 >> 24);
        out[8] = (byte)x2;
        out[9] = (byte)(x2 >> 8);
        out[10] = (byte)(x2 >> 16);
        out[11] = (byte)(x2 >> 24);
        out[12] = (byte)x3;
        out[13] = (byte)(x3 >> 8);
        out[14] = (byte)(x3 >> 16);
        out[15] = (byte)(x3 >> 24);
        out[16] = (byte)x4;
        out[17] = (byte)(x4 >> 8);
        out[18] = (byte)(x4 >> 16);
        out[19] = (byte)(x4 >> 24);
        out[20] = (byte)x5;
        out[21] = (byte)(x5 >> 8);
        out[22] = (byte)(x5 >> 16);
        out[23] = (byte)(x5 >> 24);
        out[24] = (byte)x6;
        out[25] = (byte)(x6 >> 8);
        out[26] = (byte)(x6 >> 16);
        out[27] = (byte)(x6 >> 24);
        out[28] = (byte)x7;
        out[29] = (byte)(x7 >> 8);
        out[30] = (byte)(x7 >> 16);
        out[31] = (byte)(x7 >> 24);
        out[32] = (byte)x8;
        out[33] = (byte)(x8 >> 8);
        out[34] = (byte)(x8 >> 16);
        out[35] = (byte)(x8 >> 24);
        out[36] = (byte)x9;
        out[37] = (byte)(x9 >> 8);
        out[38] = (byte)(x9 >> 16);
        out[39] = (byte)(x9 >> 24);
        out[40] = (byte)x10;
        out[41] = (byte)(x10 >> 8);
        out[42] = (byte)(x10 >> 16);
        out[43] = (byte)(x10 >> 24);
        out[44] = (byte)x11;
        out[45] = (byte)(x11 >> 8);
        out[46] = (byte)(x11 >> 16);
        out[47] = (byte)(x11 >> 24);
        out[48] = (byte)x12;
        out[49] = (byte)(x12 >> 8);
        out[50] = (byte)(x12 >> 16);
        out[51] = (byte)(x12 >> 24);
        out[52] = (byte)x13;
        out[53] = (byte)(x13 >> 8);
        out[54] = (byte)(x13 >> 16);
        out[55] = (byte)(x13 >> 24);
        out[56] = (byte)x14;
        out[57] = (byte)(x14 >> 8);
        out[58] = (byte)(x14 >> 16);
        out[59] = (byte)(x14 >> 24);
        out[60] = (byte)x15;
        out[61] = (byte)(x15 >> 8);
        out[62] = (byte)(x15 >> 16);
        out[63] = (byte)(x15 >> 24);
        return out;
    }

    public static byte[] XORKeyStream(byte[] in, byte[] counter, byte[] key) {
        byte[] block;
        byte[] out = (byte[])in.clone();
        byte[] counterCopy = (byte[])counter.clone();
        int count = 0;
        while (in.length >= 64) {
            block = Salsa.core(counterCopy, key, SIGMA);
            for (int i = 0; i < block.length; ++i) {
                byte x = block[i];
                out[i + 64 * count] = (byte)(in[i] ^ x);
            }
            long u = 1L;
            for (int i = 8; i < 16; ++i) {
                counterCopy[i] = (byte)(u += (long)(0xFF & counterCopy[i]));
                u >>= 8;
            }
            byte[] temp = (byte[])in.clone();
            in = new byte[in.length - 64];
            System.arraycopy(temp, 64, in, 0, in.length);
            ++count;
        }
        if (in.length > 0) {
            block = Salsa.core(counterCopy, key, SIGMA);
            for (int i = 0; i < in.length; ++i) {
                out[i + count * 64] = (byte)(in[i] ^ block[i]);
            }
        }
        return out;
    }

    public static byte[] HSalsa20(byte[] in, byte[] k, byte[] c) {
        long x0 = Salsa.mask(c[0]) | Salsa.mask(c[1]) << 8 | Salsa.mask(c[2]) << 16 | Salsa.mask(c[3]) << 24;
        long x1 = Salsa.mask(k[0]) | Salsa.mask(k[1]) << 8 | Salsa.mask(k[2]) << 16 | Salsa.mask(k[3]) << 24;
        long x2 = Salsa.mask(k[4]) | Salsa.mask(k[5]) << 8 | Salsa.mask(k[6]) << 16 | Salsa.mask(k[7]) << 24;
        long x3 = Salsa.mask(k[8]) | Salsa.mask(k[9]) << 8 | Salsa.mask(k[10]) << 16 | Salsa.mask(k[11]) << 24;
        long x4 = Salsa.mask(k[12]) | Salsa.mask(k[13]) << 8 | Salsa.mask(k[14]) << 16 | Salsa.mask(k[15]) << 24;
        long x5 = Salsa.mask(c[4]) | Salsa.mask(c[5]) << 8 | Salsa.mask(c[6]) << 16 | Salsa.mask(c[7]) << 24;
        long x6 = Salsa.mask(in[0]) | Salsa.mask(in[1]) << 8 | Salsa.mask(in[2]) << 16 | Salsa.mask(in[3]) << 24;
        long x7 = Salsa.mask(in[4]) | Salsa.mask(in[5]) << 8 | Salsa.mask(in[6]) << 16 | Salsa.mask(in[7]) << 24;
        long x8 = Salsa.mask(in[8]) | Salsa.mask(in[9]) << 8 | Salsa.mask(in[10]) << 16 | Salsa.mask(in[11]) << 24;
        long x9 = Salsa.mask(in[12]) | Salsa.mask(in[13]) << 8 | Salsa.mask(in[14]) << 16 | Salsa.mask(in[15]) << 24;
        long x10 = Salsa.mask(c[8]) | Salsa.mask(c[9]) << 8 | Salsa.mask(c[10]) << 16 | Salsa.mask(c[11]) << 24;
        long x11 = Salsa.mask(k[16]) | Salsa.mask(k[17]) << 8 | Salsa.mask(k[18]) << 16 | Salsa.mask(k[19]) << 24;
        long x12 = Salsa.mask(k[20]) | Salsa.mask(k[21]) << 8 | Salsa.mask(k[22]) << 16 | Salsa.mask(k[23]) << 24;
        long x13 = Salsa.mask(k[24]) | Salsa.mask(k[25]) << 8 | Salsa.mask(k[26]) << 16 | Salsa.mask(k[27]) << 24;
        long x14 = Salsa.mask(k[28]) | Salsa.mask(k[29]) << 8 | Salsa.mask(k[30]) << 16 | Salsa.mask(k[31]) << 24;
        long x15 = Salsa.mask(c[12]) | Salsa.mask(c[13]) << 8 | Salsa.mask(c[14]) << 16 | Salsa.mask(c[15]) << 24;
        long mask = 0xFFFFFFFFL;
        for (int i = 0; i < 20; i += 2) {
            long u = mask & x0 + x12;
            x4 ^= mask & (u << 7 | u >>> 25);
            u = mask & x4 + x0;
            x8 ^= mask & (u << 9 | u >>> 23);
            u = mask & x8 + x4;
            x12 ^= mask & (u << 13 | u >>> 19);
            u = mask & x12 + x8;
            x0 ^= mask & (u << 18 | u >>> 14);
            u = mask & x5 + x1;
            x9 ^= mask & (u << 7 | u >>> 25);
            u = mask & x9 + x5;
            x13 ^= mask & (u << 9 | u >>> 23);
            u = mask & x13 + x9;
            x1 ^= mask & (u << 13 | u >>> 19);
            u = mask & x1 + x13;
            x5 ^= mask & (u << 18 | u >>> 14);
            u = mask & x10 + x6;
            x14 ^= mask & (u << 7 | u >>> 25);
            u = mask & x14 + x10;
            x2 ^= mask & (u << 9 | u >>> 23);
            u = mask & x2 + x14;
            x6 ^= mask & (u << 13 | u >>> 19);
            u = mask & x6 + x2;
            x10 ^= mask & (u << 18 | u >>> 14);
            u = mask & x15 + x11;
            x3 ^= mask & (u << 7 | u >>> 25);
            u = mask & x3 + x15;
            x7 ^= mask & (u << 9 | u >>> 23);
            u = mask & x7 + x3;
            x11 ^= mask & (u << 13 | u >>> 19);
            u = mask & x11 + x7;
            x15 ^= mask & (u << 18 | u >>> 14);
            u = mask & x0 + x3;
            x1 ^= mask & (u << 7 | u >>> 25);
            u = mask & x1 + x0;
            x2 ^= mask & (u << 9 | u >>> 23);
            u = mask & x2 + x1;
            x3 ^= mask & (u << 13 | u >>> 19);
            u = mask & x3 + x2;
            x0 ^= mask & (u << 18 | u >>> 14);
            u = mask & x5 + x4;
            x6 ^= mask & (u << 7 | u >>> 25);
            u = mask & x6 + x5;
            x7 ^= mask & (u << 9 | u >>> 23);
            u = mask & x7 + x6;
            x4 ^= mask & (u << 13 | u >>> 19);
            u = mask & x4 + x7;
            x5 ^= mask & (u << 18 | u >>> 14);
            u = mask & x10 + x9;
            x11 ^= mask & (u << 7 | u >>> 25);
            u = mask & x11 + x10;
            x8 ^= mask & (u << 9 | u >>> 23);
            u = mask & x8 + x11;
            x9 ^= mask & (u << 13 | u >>> 19);
            u = mask & x9 + x8;
            x10 ^= mask & (u << 18 | u >>> 14);
            u = mask & x15 + x14;
            x12 ^= mask & (u << 7 | u >>> 25);
            u = mask & x12 + x15;
            x13 ^= mask & (u << 9 | u >>> 23);
            u = mask & x13 + x12;
            x14 ^= mask & (u << 13 | u >>> 19);
            u = mask & x14 + x13;
            x15 ^= mask & (u << 18 | u >>> 14);
        }
        byte[] out = new byte[]{(byte)x0, (byte)(x0 >> 8), (byte)(x0 >> 16), (byte)(x0 >> 24), (byte)x5, (byte)(x5 >> 8), (byte)(x5 >> 16), (byte)(x5 >> 24), (byte)x10, (byte)(x10 >> 8), (byte)(x10 >> 16), (byte)(x10 >> 24), (byte)x15, (byte)(x15 >> 8), (byte)(x15 >> 16), (byte)(x15 >> 24), (byte)x6, (byte)(x6 >> 8), (byte)(x6 >> 16), (byte)(x6 >> 24), (byte)x7, (byte)(x7 >> 8), (byte)(x7 >> 16), (byte)(x7 >> 24), (byte)x8, (byte)(x8 >> 8), (byte)(x8 >> 16), (byte)(x8 >> 24), (byte)x9, (byte)(x9 >> 8), (byte)(x9 >> 16), (byte)(x9 >> 24)};
        return out;
    }
}

