/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateEncryptedChannel;
import com.pusher.client.channel.PrivateEncryptedChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.crypto.nacl.AuthenticityException;
import com.pusher.client.crypto.nacl.SecretBoxOpener;
import com.pusher.client.crypto.nacl.SecretBoxOpenerFactory;
import com.pusher.client.util.Factory;
import com.pusher.client.util.internal.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PrivateEncryptedChannelImpl
extends ChannelImpl
implements PrivateEncryptedChannel {
    private final InternalConnection connection;
    private final Authorizer authorizer;
    private SecretBoxOpenerFactory secretBoxOpenerFactory;
    private SecretBoxOpener secretBoxOpener;
    private ConnectionEventListener disposeSecretBoxOpenerOnDisconnectedListener = new ConnectionEventListener(){

        @Override
        public void onConnectionStateChange(ConnectionStateChange change) {
            PrivateEncryptedChannelImpl.this.disposeSecretBoxOpener();
        }

        @Override
        public void onError(String message, String code, Exception e) {
        }
    };

    public PrivateEncryptedChannelImpl(InternalConnection connection, String channelName, Authorizer authorizer, Factory factory, SecretBoxOpenerFactory secretBoxOpenerFactory) {
        super(channelName, factory);
        this.connection = connection;
        this.authorizer = authorizer;
        this.secretBoxOpenerFactory = secretBoxOpenerFactory;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PrivateEncryptedChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PrivateEncryptedChannelEventListener can be bound to a private encrypted channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    public String toSubscribeMessage() {
        String authKey = this.authenticate();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("channel", this.name);
        dataMap.put("auth", authKey);
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("event", "pusher:subscribe");
        jsonObject.put("data", dataMap);
        return this.GSON.toJson(jsonObject);
    }

    private String authenticate() {
        try {
            Map authResponse = (Map)this.GSON.fromJson(this.getAuthResponse(), Map.class);
            String auth = (String)authResponse.get("auth");
            String sharedSecret = (String)authResponse.get("shared_secret");
            if (auth == null || sharedSecret == null) {
                throw new AuthorizationFailureException("Didn't receive all the fields expected from the Authorizer, expected an auth and shared_secret.");
            }
            this.createSecretBoxOpener(Base64.decode(sharedSecret));
            return auth;
        }
        catch (AuthorizationFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer", e);
        }
    }

    private void createSecretBoxOpener(byte[] key) {
        this.secretBoxOpener = this.secretBoxOpenerFactory.create(key);
        this.setListenerToDisposeSecretBoxOpenerOnDisconnected();
    }

    private void setListenerToDisposeSecretBoxOpenerOnDisconnected() {
        this.connection.bind(ConnectionState.DISCONNECTED, this.disposeSecretBoxOpenerOnDisconnectedListener);
    }

    @Override
    public void updateState(ChannelState state) {
        super.updateState(state);
        if (state == ChannelState.UNSUBSCRIBED) {
            this.disposeSecretBoxOpener();
        }
    }

    @Override
    public PusherEvent prepareEvent(String event, String message) {
        try {
            return this.decryptMessage(message);
        }
        catch (AuthenticityException e1) {
            this.disposeSecretBoxOpener();
            this.authenticate();
            try {
                return this.decryptMessage(message);
            }
            catch (AuthenticityException e2) {
                this.notifyListenersOfDecryptFailure(event, "Failed to decrypt message.");
                return null;
            }
        }
    }

    private void notifyListenersOfDecryptFailure(String event, String reason) {
        Set<SubscriptionEventListener> listeners = this.getInterestedListeners(event);
        if (listeners != null) {
            for (SubscriptionEventListener listener : listeners) {
                ((PrivateEncryptedChannelEventListener)listener).onDecryptionFailure(event, reason);
            }
        }
    }

    private PusherEvent decryptMessage(String message) {
        Map receivedMessage = (Map)this.GSON.fromJson(message, Map.class);
        EncryptedReceivedData encryptedReceivedData = (EncryptedReceivedData)this.GSON.fromJson((String)receivedMessage.get("data"), EncryptedReceivedData.class);
        String decryptedData = new String(this.secretBoxOpener.open(encryptedReceivedData.getCiphertext(), encryptedReceivedData.getNonce()));
        receivedMessage.replace("data", decryptedData);
        return new PusherEvent(receivedMessage);
    }

    private void disposeSecretBoxOpener() {
        if (this.secretBoxOpener != null) {
            this.secretBoxOpener.clearKey();
            this.secretBoxOpener = null;
            this.removeListenerToDisposeSecretBoxOpenerOnDisconnected();
        }
    }

    private void removeListenerToDisposeSecretBoxOpenerOnDisconnected() {
        this.connection.unbind(ConnectionState.DISCONNECTED, this.disposeSecretBoxOpenerOnDisconnectedListener);
    }

    private String getAuthResponse() {
        String socketId = this.connection.getSocketId();
        return this.authorizer.authorize(this.getName(), socketId);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!private-encrypted-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Private Encrypted Channel: name=%s]", this.name);
    }

    private class EncryptedReceivedData {
        String nonce;
        String ciphertext;

        private EncryptedReceivedData() {
        }

        public byte[] getNonce() {
            return Base64.decode(this.nonce);
        }

        public byte[] getCiphertext() {
            return Base64.decode(this.ciphertext);
        }
    }
}

