/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.connection.websocket;

import com.pusher.client.connection.websocket.WebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientWrapper
extends WebSocketClient {
    private static final String WSS_SCHEME = "wss";
    private final WebSocketListener proxy;

    public WebSocketClientWrapper(URI uri, WebSocketListener proxy) throws SSLException {
        super(uri);
        if (uri.getScheme().equals(WSS_SCHEME)) {
            try {
                SSLContext sslContext = null;
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                SSLSocketFactory factory = sslContext.getSocketFactory();
                this.setSocket(factory.createSocket());
            }
            catch (IOException e) {
                throw new SSLException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLException(e);
            }
            catch (KeyManagementException e) {
                throw new SSLException(e);
            }
        }
        this.proxy = proxy;
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.proxy.onOpen(handshakedata);
    }

    public void onMessage(String message) {
        this.proxy.onMessage(message);
    }

    public void onClose(int code, String reason, boolean remote) {
        this.proxy.onClose(code, reason, remote);
    }

    public void onError(Exception ex) {
        this.proxy.onError(ex);
    }
}

